package com.momiage.app.asom.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import com.momiage.app.asom.logic.SourceInfo;
import com.momiage.app.asom.logic.SourceTrackInfo;

public class SourceChaserFrame extends JFrame implements ActionListener,
		Runnable {

	private static final long serialVersionUID = 8944411566890622937L;

	private JPanel jContentPane = null;
	private JTextPane jTextPane = null;
	private JScrollPane jScrollPane = null;
	private JButton jButton = null;

	protected SourceInfo si = null;
	protected List<SourceTrackInfo> lsti = null;

	public SourceChaserFrame(SourceInfo sourceInfo, List<SourceTrackInfo> lsts) {
		si = sourceInfo;
		lsti = lsts;

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(500, 400);
		setContentPane(getJContentPane());
		setTitle("a source of music");
	}

	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJScrollPane(), BorderLayout.CENTER);
			jContentPane.add(getJButton(), BorderLayout.NORTH);
		}
		return jContentPane;
	}

	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane(getJTextPane());
			jScrollPane.setName("jScrollPane");
			jScrollPane.setVerticalScrollBarPolicy(
                    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			jScrollPane.setHorizontalScrollBarPolicy(
                    JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		}
		return jScrollPane;
	}

	private JTextPane getJTextPane() {
		if (jTextPane == null) {
			jTextPane = new JTextPane();
			jTextPane.setName("jTextPane");

			StringBuffer sb = new StringBuffer();
			Iterator<String> it = si.getSourceBody().iterator();
			while (it.hasNext()) {
				sb.append(it.next());
				sb.append("\r\n");
			}
			jTextPane.setText(sb.toString());
			jTextPane.setSelectionStart(0);
			jTextPane.setSelectionEnd(0);
		}
		return jTextPane;
	}

	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setName("jButton");
			jButton.setText("PLAY A SOURCE OF MUSIC!");
			jButton.addActionListener(this);
		}
		return jButton;
	}

	public void actionPerformed(ActionEvent arg0) {
		SequencerThread th = new SequencerThread(si, lsti, jTextPane);
		th.start();

		/*
		 * Thread th = new Thread(this); th.start();
		 */
	}

	public void run() {
		int i = 0;
		while (i < jTextPane.getText().length()) {
			jTextPane.requestFocus();
			jTextPane.setSelectionStart(0);
			jTextPane.setSelectionEnd(i++);
			try {
				Thread.sleep(500);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

}
