package com.momiage.app.asom.gui;

import java.util.Iterator;
import java.util.List;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.swing.JTextPane;

import com.momiage.app.asom.common.DebugCommon;
import com.momiage.app.asom.logic.SourceInfo;
import com.momiage.app.asom.logic.SourceTrackInfo;
import com.momiage.app.asom.logic.MusicCreator;

public class SequencerThread extends Thread {

	protected MidiChannel channel = null;
	protected Synthesizer synthesizer = null;

	protected int msecPerTick = -1;

	protected SourceInfo si = null;
	protected List<SourceTrackInfo> lsti = null;
	protected JTextPane spane = null;

	protected boolean initialized = false;

	public SequencerThread(SourceInfo sourceInfo, List<SourceTrackInfo> lsts,
			JTextPane sourcePane) {
		si = sourceInfo;
		lsti = lsts;
		spane = sourcePane;
	}

	public void init() {
		int tempo = si.getTempo();
		int l = 60 * 1000000 / tempo;
		msecPerTick = l / MusicCreator.NOTE_LEN_4 / 1000;

		initialized = true;
	}

	public void run() {
		if (!initialized) {
			init();
		}

		Soundbank soundbank = null;
		Instrument[] instruments = null;

		try {

			synthesizer = MidiSystem.getSynthesizer();
			synthesizer.open();

			soundbank = synthesizer.getDefaultSoundbank();

			instruments = soundbank.getInstruments();
			synthesizer.loadInstrument(instruments[0]);

			channel = synthesizer.getChannels()[0];

			channel.programChange(si.getInstNo() - 1);
			
			Iterator<SourceTrackInfo> it = lsti.iterator();
			SourceTrackInfo sti = null;
			if (it.hasNext()) {
				sti = it.next();
			}

			while (it.hasNext()) {
				DebugCommon.print(sti.toString());

				SourceTrackInfo nsti = it.next();

				int pos = sti.getCharpos();
				spane.requestFocus();
				spane.setSelectionStart(0);
				spane.setSelectionEnd(pos);

				if (sti.getMes() == ShortMessage.NOTE_OFF) {
					channel.allNotesOff();
					
				} else {
					channel.noteOn(sti.getPitch(), 127);
				}
				int sleepTick = nsti.getTick() - sti.getTick();
				if (0 < sleepTick) {
					sleep(sleepTick * msecPerTick);
				}
				sti = nsti;
			}

			spane.requestFocus();
			spane.setSelectionStart(0);
			spane.setSelectionEnd(spane.getText().length());

			channel.allNotesOff();

			synthesizer.close();

		} catch (Exception e) {
			if (channel != null) {
				channel.allNotesOff();
			}
		}

	}
	
}
