package jp.sourceforge.asclipse.as3.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;

import jp.sourceforge.asclipse.as3.IAS3Context;
import jp.sourceforge.asclipse.as3.ParserUtil;
import jp.sourceforge.asclipse.as3.element.AS3Element;
import jp.sourceforge.asclipse.as3.element.AS3Root;
import jp.sourceforge.asclipse.as3.element.AS3Type;
import jp.sourceforge.asclipse.as3.internal.DefaultAS3Context;

/**
 * ビルトインasファイルを解析し、シリアライズする。
 * @author shin1
 */
public class AS3ContextToFile {

	private AS3ContextToFile() {
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Map<File, AS3Root> parseAll =
				ParserUtil.parseAll(new File("src/main/resources/as"), new String[0]);
		IAS3Context context = new DefaultAS3Context("builtin");
		for (AS3Root root : parseAll.values()) {
			List<AS3Element> children = root.getChildren();
			boolean hasType = false;
			for (AS3Element element : children) {
				if (element instanceof AS3Type) {
					hasType = true;
				}
			}
			if (!hasType) {
				System.err.println(root.getResourceName() + " doen't have as3type.");
			}
			context.addAS3Root(root);
		}
		ObjectOutputStream out = null;
		try {
			out = new ObjectOutputStream(new FileOutputStream("target/builtin.ser"));
			out.writeObject(context);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}
}
