package jp.sourceforge.asclipse.as3.rules;

import jp.sourceforge.asclipse.as3.AS3Parser;
import jp.sourceforge.asclipse.as3.DebugUtil;
import jp.sourceforge.asclipse.as3.AS3Parser.useNamespaceDirective_return;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

/**
 * useNamespaceDirectiveルールのテストケース。
 * @author shin1ogawa
 */
@RunWith(Theories.class)
public class UseNamespaceDirectiveTest {

	/** テストする単語 */
	public static @DataPoints
	String[] words = {
		"use namespace namespace1;",
		"use namespace namespace2,namespace3;",
	};


	/**
	 * @param word
	 * @throws RecognitionException
	 */
	@Theory
	public void parse(String word) throws RecognitionException {
		AS3Parser parser = RuleTestUtil.createParser(word);
		useNamespaceDirective_return result = parser.useNamespaceDirective();
		RuleTestUtil.assertParsedResult(parser, word, result);
		DebugUtil.debug((CommonTree) result.getTree());
	}
}
