package jp.sourceforge.asclipse.as3.rules;

import jp.sourceforge.asclipse.as3.AS3Parser;
import jp.sourceforge.asclipse.as3.AS3Parser.typePostfixSyntax_return;

import org.antlr.runtime.RecognitionException;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

/**
 * typePostfixSyntaxルールのテストケース。
 * @author shin1ogawa
 */
@RunWith(Theories.class)
public class TypePostFixSyntaxTest {

	/** テストする単語 */
	public static @DataPoints
	String[] words = {
		".<T>",
		".<MyClass>",
		".<com.MyClass>",
	//".<Vector.<String>>"
			};


	/**
	 * @param word
	 * @throws RecognitionException
	 */
	@Theory
	public void parse(String word) throws RecognitionException {
		AS3Parser parser = RuleTestUtil.createParser(word);
		typePostfixSyntax_return result = parser.typePostfixSyntax();
		RuleTestUtil.assertParsedResult(parser, word, result);
	}
}
