package jp.sourceforge.asclipse.as3.rules;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import java.util.List;

import jp.sourceforge.asclipse.as3.AS3Lexer;
import jp.sourceforge.asclipse.as3.AS3Parser;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * antlrで定義したruleのテストをするためのユーティリティクラス。
 * @author shin1ogawa
 */
public class RuleTestUtil {

	private static final Logger logger = LoggerFactory.getLogger(RuleTestUtil.class);


	/**
	 * @param testString
	 * @return 特定の入力をパースするためのParser
	 */
	public static AS3Parser createParser(String testString) {
		CharStream stream = new ANTLRStringStream(testString);
		AS3Lexer lexer = new AS3Lexer(stream);
		CommonTokenStream tokens = new CommonTokenStream(lexer);
		AS3Parser parser = new AS3Parser(tokens);
		return parser;
	}

	/**
	 * パースが問題無く行われたかどうかを評価する。
	 * @param parser
	 * @param testString
	 * @param result
	 */
	public static void assertParsedResult(AS3Parser parser, String testString, Object result) {
		assertThat(result, notNullValue());
		if (parser.getParseErrors() != null) {
			List<Exception> parseErrors = parser.getParseErrors();
			for (Exception exception : parseErrors) {
				logger.warn("fail to parse:" + testString, exception);
			}
		}
		assertThat("fail to parse:" + testString, parser.getParseErrors(), nullValue());
	}
}
