package jp.sourceforge.asclipse.as3.rules;

import jp.sourceforge.asclipse.as3.AS3Parser;
import jp.sourceforge.asclipse.as3.DebugUtil;
import jp.sourceforge.asclipse.as3.AS3Parser.includeDirective_return;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

/**
 * useNamespaceDirectiveルールのテストケース。
 * @author shin1ogawa
 */
@RunWith(Theories.class)
public class IncludeTest {

	/** テストする単語 */
	public static @DataPoints
	String[] words = {
		"include \"hoge.as\";",
	};


	/**
	 * @param word
	 * @throws RecognitionException
	 */
	@Theory
	public void parse(String word) throws RecognitionException {
		AS3Parser parser = RuleTestUtil.createParser(word);
		includeDirective_return result = parser.includeDirective();
		RuleTestUtil.assertParsedResult(parser, word, result);
		DebugUtil.debug((CommonTree) result.getTree());
	}
}
