package jp.sourceforge.asclipse.as3.rules;

import jp.sourceforge.asclipse.as3.AS3Parser;
import jp.sourceforge.asclipse.as3.AS3Parser.ifStatement_return;

import org.antlr.runtime.RecognitionException;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.slf4j.LoggerFactory;

/**
 * functionDeclarationルールのテストケース。
 * @author shin1ogawa
 */
@RunWith(Theories.class)
public class IfStatementTest {

	/** テストする単語 */
	public static @DataPoints
	String[] statements =
			{
				"if (a()) { doA(); }",
				"if (a()) { doA(); } else { doElse(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }" + " else if (c()) { doC(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }" + " else if (c()) { doC(); }"
						+ " else if (d()) { doD(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }" + " else if (c()) { doC(); }"
						+ " else if (d()) { doD(); }" + " else if (e()) { doE(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }" + " else if (c()) { doC(); }"
						+ " else if (d()) { doD(); }" + " else if (e()) { doE(); }"
						+ " else if (f()) { doF(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }" + " else if (c()) { doC(); }"
						+ " else if (d()) { doD(); }" + " else if (e()) { doE(); }"
						+ " else if (f()) { doF(); }" + " else if (g()) { doG(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }" + " else if (c()) { doC(); }"
						+ " else if (d()) { doD(); }" + " else if (e()) { doE(); }"
						+ " else if (f()) { doF(); }" + " else if (g()) { doG(); }"
						+ " else if (h()) { doH(); }",
				"if (a()) { doA(); }" + " else if (b()) { doB(); }" + " else if (c()) { doC(); }"
						+ " else if (d()) { doD(); }" + " else if (e()) { doE(); }"
						+ " else if (f()) { doF(); }" + " else if (g()) { doG(); }"
						+ " else if (h()) { doH(); }" + " else if (i()) { doI(); }",
			};


	/**
	 * @param statement
	 * @throws RecognitionException
	 */
	@Theory
	public void parse(String statement) throws RecognitionException {
		LoggerFactory.getLogger(IfStatementTest.class).debug(statement);
		long before = System.currentTimeMillis();
		AS3Parser parser = RuleTestUtil.createParser(statement);
		ifStatement_return result = parser.ifStatement();
		RuleTestUtil.assertParsedResult(parser, statement, result);
		LoggerFactory.getLogger(IfStatementTest.class).debug(
				"time:ms=" + (System.currentTimeMillis() - before));
	}
}
