package jp.sourceforge.asclipse.as3.rules;

import jp.sourceforge.asclipse.as3.AS3Parser;
import jp.sourceforge.asclipse.as3.AS3Parser.functionDeclaration_return;

import org.antlr.runtime.RecognitionException;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

/**
 * functionDeclarationルールのテストケース。
 * @author shin1ogawa
 */
@RunWith(Theories.class)
public class FunctionDeclarationTest {

	/** テストする単語 */
	public static @DataPoints
	String[] words = {
		"function a() {}",
		"static function a(){}",
		"function a():int {}",
		"function a():* {}",
		"function a(a):int {}",
		"function a(a:int):int {}",
		"function a(a:*):int {}",
		"function a(a:*, b):int {}",
		"function a(a:* =null, b):int {}",
		"function a(a:* =null, b:int = 10):int {}",
		"function namespace():* {}",
		"public function trace (...arguments) : void {}"
	};


	/**
	 * @param word
	 * @throws RecognitionException
	 */
	@Theory
	public void parse(String word) throws RecognitionException {
		AS3Parser parser = RuleTestUtil.createParser(word);
		functionDeclaration_return result = parser.functionDeclaration();
		RuleTestUtil.assertParsedResult(parser, word, result);
	}
}
