package jp.sourceforge.asclipse.as3.rules;

import jp.sourceforge.asclipse.as3.AS3Parser;
import jp.sourceforge.asclipse.as3.AS3Parser.formalParameterListInner_return;

import org.antlr.runtime.RecognitionException;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

/**
 * functionDeclarationルールのテストケース。
 * @author shin1ogawa
 */
@RunWith(Theories.class)
public class FormalParameterListInnerTest {

	/** テストする単語 */
	public static @DataPoints
	String[] words = {
		"arg1",
		"arg1:int",
		"arg1:int = 10",
		"...args",
	};


	/**
	 * @param word
	 * @throws RecognitionException
	 */
	@Theory
	public void parse(String word) throws RecognitionException {
		AS3Parser parser = RuleTestUtil.createParser(word);
		formalParameterListInner_return result = parser.formalParameterListInner();
		RuleTestUtil.assertParsedResult(parser, word, result);
	}
}
