package jp.sourceforge.asclipse.as3.adapter;

import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.asclipse.as3.ParserUtil;
import jp.sourceforge.asclipse.as3.ParserUtilTest;
import jp.sourceforge.asclipse.as3.ParserUtil.AS3ParserException;
import jp.sourceforge.asclipse.as3.element.AS3Class;
import jp.sourceforge.asclipse.as3.element.AS3Element;
import jp.sourceforge.asclipse.as3.element.AS3Property;
import jp.sourceforge.asclipse.as3.element.AS3Root;
import jp.sourceforge.asclipse.as3.element.AS3Variable;

import org.antlr.runtime.RecognitionException;
import org.junit.Test;

/**
 * {@link GetElementAt}のテストケース。
 * @author shin1ogawa
 */
public class GetElementAtTest {

	private GetElementAt parseSample01() throws AS3ParserException {
		final String asFileName = "/Sample01.as";
		InputStream input = ParserUtilTest.class.getResourceAsStream(asFileName);
		assertThat(input, notNullValue());
		AS3Root rootElement = ParserUtil.parse(input, asFileName);
		GetElementAt adapter = new GetElementAt();
		rootElement.addAdapter(adapter);
		return adapter;
	}

	/**
	 * 範囲内の場合
	 * @throws IOException
	 * @throws RecognitionException
	 * @throws AS3ParserException
	 */
	@Test
	public void test01() throws IOException, RecognitionException, AS3ParserException {
		GetElementAt adapter = parseSample01();
		AS3Element elementAt = adapter.getElementAt(10, 5);
		assertThat(elementAt, instanceOf(AS3Class.class));
		elementAt = adapter.getElementAt(12, 5); // var fiel[|]d03:Number;
		assertThat(elementAt, instanceOf(AS3Variable.class));
		elementAt = adapter.getElementAt(11, 2); // v[|]ar field03:Number;
		assertThat(elementAt, instanceOf(AS3Property.class));
	}

	/**
	 * 範囲外の場合
	 * @throws IOException
	 * @throws RecognitionException
	 * @throws AS3ParserException
	 */
	@Test
	public void test02() throws IOException, RecognitionException, AS3ParserException {
		GetElementAt adapter = parseSample01();
		AS3Element elementAt = adapter.getElementAt(100, 5);
		assertThat(elementAt, nullValue());
		elementAt = adapter.getElementAt(0, 0);
		assertThat(elementAt, nullValue());
	}
}
