package jp.sourceforge.asclipse.as3;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.asclipse.as3.AS3Parser.fileContents_return;

import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.junit.Test;

/**
 * @author shin1ogawa
 */
public class TreeTest {

	@Test
	public void sample01() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/Sample01.as");
		debug(input);
	}

	@Test
	public void sample04() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/Sample04.as");
		debug(input);
	}

	@Test
	public void sample06() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/Sample06.as");
		debug(input);
	}

	@Test
	public void sample07() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/Sample07.as");
		debug(input);
	}

	@Test
	public void sample08() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/Sample08.as");
		debug(input);
	}

	@Test
	public void sample09() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/Sample09.as");
		debug(input);
	}

	@Test
	public void sample10() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/Sample10.as");
		debug(input);
	}

	@Test
	public void aslimtimer() throws IOException, RecognitionException {
		InputStream input = TreeTest.class.getResourceAsStream("/ASlimTimer.as");
		debug(input);
	}

	private void debug(InputStream input) throws IOException, RecognitionException {
		ANTLRInputStream antlrIs;
		antlrIs = new ANTLRInputStream(input);
		AS3Lexer lexer = new AS3Lexer(antlrIs);
		CommonTokenStream tokenStream = new CommonTokenStream(lexer);
		AS3Parser parser = new AS3Parser(tokenStream);
		fileContents_return fileContents = parser.fileContents();
		assertThat(fileContents, notNullValue());
		CommonTree tree = (CommonTree) fileContents.getTree();
		assertThat(tree, notNullValue());
		DebugUtil.debug(tree);
		assertThat(parser.getParseErrors(), nullValue());
	}
}
