package jp.sourceforge.asclipse.as3;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import java.io.IOException;
import java.io.InputStream;

import jp.sourceforge.asclipse.as3.builder.TreeBuilder;
import jp.sourceforge.asclipse.as3.element.AS3Element;
import jp.sourceforge.asclipse.as3.internal.DefaultAS3GlobalContext;

import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * {@link AS3Parser}のためのテストケース。
 * @author shin1ogawa
 */
@RunWith(Theories.class)
public class ParserTest {

	private static final Logger LOGGER = LoggerFactory.getLogger(ParserTest.class);

	/** {@link #parse01(String)}へのパラメータとなる、テスト用ASファイル名 */
	public static @DataPoints
	String[] asFileNames = {
		"/Sample01.as",
		"/Sample02.as",
		"/Sample03.as",
		"/Sample04.as",
		"/Sample05.as",
		"/Sample06.as",
		"/Sample07.as",
		"/Sample08.as",
		"/Sample09.as",
		"/AccessInterface.as",
		"/AccountController.as",
		"/ASlimTimer.as",
		"/DeleteAlarmCommand.as",
		"/EditTimeEntryScript.as",
		"/SlimTimerController.as"
	/*,"/EditTimeEntry.mxml"*/
	};


	/**
	 * ASファイルを読み込んで、ルート配下のtreeがnullでないかを確認するだけのテスト。
	 * @param asFileName
	 * @throws IOException
	 * @throws RecognitionException
	 */
	@Theory
	public void parse01(String asFileName) throws IOException, RecognitionException {
		LOGGER.info("parse start: " + asFileName);
		InputStream input = ParserTest.class.getResourceAsStream(asFileName);
		assertThat(input, notNullValue());

		ANTLRInputStream antlrIs = new ANTLRInputStream(input);
		AS3Lexer lexer = new AS3Lexer(antlrIs);
		CommonTokenStream tokenStream = new CommonTokenStream(lexer);
		AS3Parser parser = new AS3Parser(tokenStream);
		parser.setBacktrackingLevel(0);
		AS3Parser.fileContents_return fileContents = parser.fileContents();
		assertThat(fileContents, notNullValue());
		CommonTree tree = (CommonTree) fileContents.getTree();
		assertThat(tree, notNullValue());
		AS3Element root = new TreeBuilder().build(new DefaultAS3GlobalContext(), tree);
		assertThat(root, notNullValue());
		assertThat(parser.getParseErrors(), nullValue());

		LOGGER.info("parse end: " + asFileName);
	}
}
