package mx.rpc.wsdl {
	import mx.logging.ILogger;
	import mx.logging.Log;
	import mx.resources.IResourceManager;
	import mx.resources.ResourceManager;
	import mx.rpc.Fault;
	import mx.rpc.soap.SOAPConstants;
	import mx.rpc.xml.QualifiedResourceManager;
	import mx.rpc.xml.Schema;
	import mx.rpc.xml.SchemaConstants;
	import mx.rpc.xml.SchemaManager;
	import mx.rpc.xml.SchemaTypeRegistry;
	public class WSDL {
		public function WSDL(xml:XML,topLevelManager:SchemaManager=null);
		private var resourceManager:IResourceManager;
		public function get schemaManager():SchemaManager;
		public function get schemaConstants():SchemaConstants;
		public function get soapConstants():SOAPConstants;
		public function get targetNamespace():Namespace;
		public function get wsdlConstants():WSDLConstants;
		public function get xml():XML;
		public function addImport(targetNamespace:Namespace,wsdl:WSDL):void;
		public function addSchema(schema:Schema):void;
		public function getOperation(operationName:String,serviceName:String=null,portName:String=null):WSDLOperation;
		public function getPort(serviceName:String=null,portName:String=null):WSDLPort;
		public function getService(serviceName:String=null,portName:String=null):WSDLService;
		public function getTypes(targetNamespace:Namespace):XML;
		private function parseService(serviceName:String=null,portName:String=null):WSDLService;
		private function parsePort(service:WSDLService,serviceXML:XML,portName:String=null):WSDLPort;
		private function parseBinding(bindingQName:QName):WSDLBinding;
		private function parsePortType(portTypeQName:QName,portType:WSDLPortType):Boolean;
		private function parseMessage(message:WSDLMessage,messageQName:QName,operationName:String,mode:int):Boolean;
		private function parseMessagePart(partXML:XML):WSDLMessagePart;
		private function parseHeader(operationName:String,headerXML:XML):WSDLMessage;
		private function parseEncodingExtension(extensionXML:XML,isHeader:Boolean=false,isFault:Boolean=false):WSDLEncoding;
		private function parseDocumentOperation(operation:WSDLOperation):void;
		private function parseWrappedMessagePart(elementXML:XML):WSDLMessagePart;
		private function processNamespaces():void;
		private function processSchemas():void;
		private var importsManager:QualifiedResourceManager;
		private var _log:ILogger;
		private var namespaces:Object;
		private var _schemaConstants:SchemaConstants;
		private var _schemaManager:SchemaManager;
		private var serviceMap:Object;
		private var _soapConstants:SOAPConstants;
		private var _targetNamespace:Namespace;
		private var _wsdlConstants:WSDLConstants;
		private var _xml:XML;
	}
}
