package mx.resources {
	import flash.events.IEventDispatcher;
	import flash.system.ApplicationDomain;
	import flash.system.SecurityDomain;
	public interface IResourceManager extends IEventDispatcher {
		function get localeChain():Array;
		function set localeChain(value:Array):void;
		function loadResourceModule(url:String,update:Boolean=true,applicationDomain:ApplicationDomain=null,securityDomain:SecurityDomain=null):IEventDispatcher;
		function unloadResourceModule(url:String,update:Boolean=true):void;
		function addResourceBundle(resourceBundle:IResourceBundle):void;
		function removeResourceBundle(locale:String,bundleName:String):void;
		function removeResourceBundlesForLocale(locale:String):void;
		function update():void;
		function getLocales():Array;
		function getPreferredLocaleChain():Array;
		function getBundleNamesForLocale(locale:String):Array;
		function getResourceBundle(locale:String,bundleName:String):IResourceBundle;
		function findResourceBundleWithResource(bundleName:String,resourceName:String):IResourceBundle;
		function getObject(bundleName:String,resourceName:String,locale:String=null):*;
		function getString(bundleName:String,resourceName:String,parameters:Array=null,locale:String=null):String;
		function getStringArray(bundleName:String,resourceName:String,locale:String=null):Array;
		function getNumber(bundleName:String,resourceName:String,locale:String=null):Number;
		function getInt(bundleName:String,resourceName:String,locale:String=null):int;
		function getUint(bundleName:String,resourceName:String,locale:String=null):uint;
		function getBoolean(bundleName:String,resourceName:String,locale:String=null):Boolean;
		function getClass(bundleName:String,resourceName:String,locale:String=null):Class;
		function installCompiledResourceBundles(applicationDomain:ApplicationDomain,locales:Array,bundleNames:Array):void;
		function initializeLocaleChain(compiledLocales:Array):void;
	}
}
