	package mx.messaging {
		import flash.errors.IllegalOperationError;
		import flash.events.EventDispatcher;
		import flash.events.TimerEvent;
		import flash.utils.Dictionary;
		import flash.utils.Timer;
		import mx.core.mx_internal;
		import mx.events.PropertyChangeEvent;
		import mx.messaging.channels.NetConnectionChannel;
		import mx.messaging.config.ServerConfig;
		import mx.messaging.errors.NoChannelAvailableError;
		import mx.messaging.events.ChannelEvent;
		import mx.messaging.events.ChannelFaultEvent;
		import mx.messaging.events.MessageEvent;
		import mx.messaging.events.MessageFaultEvent;
		import mx.messaging.messages.AcknowledgeMessage;
		import mx.messaging.messages.CommandMessage;
		import mx.messaging.messages.ErrorMessage;
		import mx.messaging.messages.IMessage;
		import mx.resources.IResourceManager;
		import mx.resources.ResourceManager;
		import mx.rpc.AsyncToken;
		import mx.rpc.events.AbstractEvent;
		import mx.rpc.events.FaultEvent;
		import mx.rpc.events.ResultEvent;
		import mx.utils.Base64Encoder;
		public class ChannelSet extends EventDispatcher {
			public function ChannelSet(channelIds:Array=null,clusteredWithURLLoadBalancing:Boolean=false);
			private var _authAgent:AuthenticationAgent;
			private var _connecting:Boolean;
			private var _credentials:String;
			private var _credentialsCharset:String;
			private var _currentChannelIndex:int;
			private var _hasRequestedClusterEndpoints:Boolean;
			private var _hunting:Boolean;
			private var _pendingMessages:Dictionary;
			private var _pendingSends:Array;
			private var _reconnectTimer:Timer;
			private var _shouldBeConnected:Boolean;
			private var _shouldHunt:Boolean;
			private var resourceManager:IResourceManager;
			private var _authenticated:Boolean;
			public function get authenticated():Boolean;
			mx_internal function setAuthenticated(value:Boolean,creds:String,notifyAgents:Boolean=true):void;
			private var _channels:Array;
			public function get channels():Array;
			public function set channels(values:Array):void;
			private var _channelIds:Array;
			public function get channelIds():Array;
			private var _currentChannel:Channel;
			public function get currentChannel():Channel;
			private var _channelFailoverURIs:Object;
			mx_internal function get channelFailoverURIs():Object;
			mx_internal function set channelFailoverURIs(value:Object):void;
			private var _configured:Boolean;
			mx_internal function get configured():Boolean;
			private var _connected:Boolean;
			public function get connected():Boolean;
			protected function setConnected(value:Boolean):void;
			private var _clustered:Boolean;
			public function get clustered():Boolean;
			public function set clustered(value:Boolean):void;
			private var _initialDestinationId:String;
			public function get initialDestinationId():String;
			public function set initialDestinationId(value:String):void;
			private var _messageAgents:Array;
			public function get messageAgents():Array;
			override public function toString():String;
			public function addChannel(channel:Channel):void;
			public function removeChannel(channel:Channel):void;
			public function connect(agent:MessageAgent):void;
			public function disconnect(agent:MessageAgent):void;
			public function disconnectAll():void;
			public function channelConnectHandler(event:ChannelEvent):void;
			public function channelDisconnectHandler(event:ChannelEvent):void;
			public function channelFaultHandler(event:ChannelFaultEvent):void;
			public function login(username:String,password:String,charset:String=null):AsyncToken;
			public function logout(agent:MessageAgent=null):AsyncToken;
			public function send(agent:MessageAgent,message:IMessage):void;
			public function setCredentials(credentials:String,agent:MessageAgent,charset:String=null):void;
			mx_internal function authenticationSuccess(agent:AuthenticationAgent,token:AsyncToken,ackMessage:AcknowledgeMessage):void;
			mx_internal function authenticationFailure(agent:AuthenticationAgent,token:AsyncToken,faultMessage:ErrorMessage):void;
			private function connectChannel():void;
			private function disconnectChannel():void;
			private function dispatchRPCEvent(event:AbstractEvent):void;
			private function messageHandler(event:MessageEvent):void;
			private function hunt():Boolean;
			private function reconnectChannel(event:TimerEvent):void;
			private function faultPendingSends(event:ChannelEvent):void;
		}
	}
	import mx.core.mx_internal;
	import mx.messaging.ChannelSet;
	import mx.messaging.MessageAgent;
	import mx.messaging.MessageResponder;
	import mx.logging.Log;
	import mx.messaging.messages.IMessage;
	import mx.messaging.messages.AcknowledgeMessage;
	import mx.messaging.messages.CommandMessage;
	import mx.messaging.messages.ErrorMessage;
	import mx.rpc.AsyncToken;
	class ClusterMessageResponder extends MessageResponder {
		public function ClusterMessageResponder(message:IMessage,channelSet:ChannelSet);
		private var _channelSet:ChannelSet;
		override protected function resultHandler(message:IMessage):void;
	}
	class PendingSend {
		public function PendingSend(agent:MessageAgent,message:IMessage);
		public var agent:MessageAgent;
		public var message:IMessage;
	}
	class AuthenticationAgent extends MessageAgent {
		public static const LOGGED_OUT_STATE:int=0;
		public static const LOGGING_IN_STATE:int=1;
		public static const LOGGED_IN_STATE:int=2;
		public static const LOGGING_OUT_STATE:int=3;
		public static const SHUTDOWN_STATE:int=4;
		public function AuthenticationAgent(channelSet:ChannelSet);
		private var tokens:Object;
		private var _state:int;
		public function get state():int;
		public function set state(value:int):void;
		public function registerToken(token:AsyncToken):void;
		override public function acknowledge(ackMsg:AcknowledgeMessage,msg:IMessage):void;
		override public function fault(errMsg:ErrorMessage,msg:IMessage):void;
	}
