	package mx.controls.videoClasses {
		import flash.events.Event;
		import flash.events.NetStatusEvent;
		import flash.events.ProgressEvent;
		import flash.events.TimerEvent;
		import flash.media.SoundTransform;
		import flash.media.Video;
		import flash.net.NetConnection;
		import flash.net.NetStream;
		import flash.utils.Timer;
		import mx.core.mx_internal;
		import mx.events.MetadataEvent;
		import mx.events.VideoEvent;
		import mx.resources.IResourceManager;
		import mx.resources.ResourceManager;
		public class VideoPlayer extends Video {
			include "../../core/Version.as";
			public static const DISCONNECTED:String="disconnected";
			public static const STOPPED:String="stopped";
			public static const PLAYING:String="playing";
			public static const PAUSED:String="paused";
			public static const BUFFERING:String="buffering";
			public static const LOADING:String="loading";
			public static const CONNECTION_ERROR:String="connectionError";
			public static const REWINDING:String="rewinding";
			public static const SEEKING:String="seeking";
			public static const RESIZING:String="resizing";
			public static const EXEC_QUEUED_CMD:String="execQueuedCmd";
			private static const BUFFER_EMPTY:String="bufferEmpty";
			private static const BUFFER_FULL:String="bufferFull";
			private static const BUFFER_FLUSH:String="bufferFlush";
			public static const DEFAULT_UPDATE_TIME_INTERVAL:Number=250;
			public static const DEFAULT_UPDATE_PROGRESS_INTERVAL:Number=250;
			public static const DEFAULT_IDLE_TIMEOUT_INTERVAL:Number=300000;
			public static const AUTO_RESIZE_INTERVAL:Number=100;
			public static const AUTO_RESIZE_PLAYHEAD_TIMEOUT:Number=.5;
			public static const AUTO_RESIZE_METADATA_DELAY_MAX:Number=5;
			public static const FINISH_AUTO_RESIZE_INTERVAL:Number=250;
			public static const RTMP_DO_STOP_AT_END_INTERVAL:Number=500;
			public static const RTMP_DO_SEEK_INTERVAL:Number=100;
			public static const HTTP_DO_SEEK_INTERVAL:Number=250;
			public static const HTTP_DO_SEEK_MAX_COUNT:Number=4;
			public static const CLOSE_NS_INTERVAL:Number=.25;
			public static const HTTP_DELAYED_BUFFERING_INTERVAL:Number=100;
			public static var DEFAULT_INCMANAGER:Class;
			public function VideoPlayer(width:uint,height:uint,ncMgrClassName:Class=null);
			public var autoBandWidthDetection:Boolean;
			private var cachedState:String;
			private var bufferState:String;
			private var sawPlayStop:Boolean;
			private var cachedPlayheadTime:Number;
			private var startingPlay:Boolean;
			private var invalidSeekRecovery:Boolean;
			private var invalidSeekTime:Boolean;
			private var readyDispatched:Boolean;
			private var lastUpdateTime:Number;
			private var sawSeekNotify:Boolean;
			public var ncMgrClassName:Class;
			private var ns:VideoPlayerNetStream;
			private var currentPos:Number;
			private var atEnd:Boolean;
			private var streamLength:Number;
			private var autoPlay:Boolean;
			private var _priorBytesLoaded:int;
			private var internalVideoWidth:Number;
			private var internalVideoHeight:Number;
			private var prevVideoWidth:Number;
			private var prevVideoHeight:Number;
			private var updateTimeTimer:Timer;
			private var updateProgressTimer:Timer;
			private var idleTimeoutTimer:Timer;
			private var autoResizeTimer:Timer;
			private var rtmpDoStopAtEndTimer:Timer;
			private var rtmpDoSeekTimer:Timer;
			private var httpDoSeekTimer:Timer;
			private var finishAutoResizeTimer:Timer;
			private var delayedBufferingTimer:Timer;
			private var httpDoSeekCount:Number;
			private var cmdQueue:Array;
			private var resourceManager:IResourceManager;
			override public function set scaleX(xs:Number):void;
			override public function set scaleY(ys:Number):void;
			override public function set width(value:Number):void;
			override public function set height(value:Number):void;
			override public function get videoWidth():int;
			override public function get videoHeight():int;
			private var _visible:Boolean;
			override public function get visible():Boolean;
			override public function set visible(v:Boolean):void;
			private var _autoRewind:Boolean;
			public function get autoRewind():Boolean;
			public function set autoRewind(flag:Boolean):void;
			public function get playheadTime():Number;
			public function set playheadTime(position:Number):void;
			private var _url:String;
			public function get url():String;
			private var _volume:Number;
			public function get volume():Number;
			public function set volume(aVol:Number):void;
			private var _soundTransform:SoundTransform;
			public function get soundTransform():SoundTransform;
			public function set soundTransform(s:SoundTransform):void;
			public function get isRTMP():Boolean;
			private var _isLive:Boolean;
			public function get isLive():Boolean;
			private var _state:String;
			public function get state():String;
			public function get stateResponsive():Boolean;
			public function get bytesLoaded():int;
			public function get bytesTotal():int;
			public function get totalTime():Number;
			private var _bufferTime:Number;
			public function get bufferTime():Number;
			public function set bufferTime(aTime:Number):void;
			public function get idleTimeout():uint;
			public function set idleTimeout(aTime:uint):void;
			public function get playheadUpdateInterval():uint;
			public function set playheadUpdateInterval(aTime:uint):void;
			public function get progressInterval():uint;
			public function set progressInterval(aTime:uint):void;
			private var _ncMgr:INCManager;
			public function get ncMgr():INCManager;
			private var _metadata:Object;
			public function get metadata():Object;
			public function setSize(w:Number,h:Number):void;
			public function setScale(xs:Number,ys:Number):void;
			public function play(url:String=null,isLive:Boolean=false,totalTime:Number=-1):void;
			public function load(url:String,isLive:Boolean=false,totalTime:Number=-1):void;
			public function pause():void;
			public function stop():void;
			public function seek(time:Number):void;
			public function close():void;
			public function doUpdateTime(event:Event):void;
			public function doUpdateProgress(event:Event):void;
			public function rtmpOnStatus(event:NetStatusEvent):void;
			public function httpOnStatus(event:NetStatusEvent):void;
			public function ncConnected():void;
			public function ncReconnected():void;
			public function onMetaData(info:Object):void;
			public function onCuePoint(info:Object):void;
			private function _load(url:String,isLive:Boolean,totalTime:Number):void;
			private function setState(s:String):void;
			private function setStateFromCachedState():void;
			private function recoverInvalidSeek():void;
			private function createINCManager():void;
			private function rtmpDoStopAtEnd(event:TimerEvent):void;
			private function rtmpDoSeek():void;
			private function httpDoStopAtEnd():void;
			private function doSeek(event:Event):void;
			private function closeNS(updateCurrentPos:Boolean=true):void;
			private function doDelayedBuffering(event:Event):void;
			private function _pause(doPause:Boolean):void;
			private function _play(...rest):void;
			private function _seek(time:Number):void;
			private function isXnOK():Boolean;
			private function doAutoResize(event:Event):void;
			private function finishAutoResize(event:Event):void;
			private function createStream():void;
			private function setUpStream():void;
			private function doIdleTimeout(event:Event):void;
			private function flushQueuedCmds():void;
			private function execQueuedCmds():void;
			private function queueCmd(type:uint,url:String=null,isLive:Boolean=false,time:Number=0):void;
		}
	}
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import mx.controls.videoClasses.VideoPlayer;
	dynamic class VideoPlayerNetStream extends NetStream {
		public function VideoPlayerNetStream(connection:NetConnection,videoPlayer:VideoPlayer);
		private var videoPlayer:VideoPlayer;
		public function onMetaData(info:Object,...rest):void;
		public function onCuePoint(info:Object,...rest):void;
		public function onPlayStatus(...rest):void;
	}
