package mx.automation {
	import flash.display.DisplayObject;
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import mx.automation.events.AutomationReplayEvent;
	public interface IAutomationManager extends IEventDispatcher {
		public function get automationEnvironment():Object;
		public function set automationEnvironment(value:Object):void;
		public function get recording():Boolean;
		public function get replaying():Boolean;
		public function beginRecording():void;
		public function createID(obj:IAutomationObject, relativeToParent:IAutomationObject = null):AutomationID;
		public function createIDPart(obj:IAutomationObject, parent:IAutomationObject = null):AutomationIDPart;
		public function decrementCacheCounter(clearNow:Boolean = false):int;
		public function endRecording():void;
		public function getAutomationClassName(obj:IAutomationObject):String;
		public function getAutomationName(obj:IAutomationObject):String;
		public function getChildren(obj:IAutomationObject, ignoreShowInHierarchy:Boolean = false):Array;
		public function getChildrenFromIDPart(obj:IAutomationObject, part:AutomationIDPart = null, ignoreShowInHierarchy:Boolean = false):Array;
		public function getElementFromPoint(x:int, y:int):IAutomationObject;
		public function getParent(obj:IAutomationObject, parentToStopAt:IAutomationObject = null, ignoreShowInHierarchy:Boolean = false):IAutomationObject;
		public function getProperties(obj:IAutomationObject, names:Array = null, forVerification:Boolean = true, forDescription:Boolean = true):Array;
		public function getRectangle(obj:DisplayObject):Array;
		public function getTabularData(obj:IAutomationObject):IAutomationTabularData;
		public function incrementCacheCounter():int;
		public function isSynchronized(target:IAutomationObject):Boolean;
		public function isVisible(obj:DisplayObject):Boolean;
		public function recordAutomatableEvent(recorder:IAutomationObject, event:Event, cacheable:Boolean = false):void;
		public function replayAutomatableEvent(event:AutomationReplayEvent):Boolean;
		public function resolveID(rid:AutomationID, currentParent:IAutomationObject = null):Array;
		public function resolveIDPart(parent:IAutomationObject, part:AutomationIDPart):Array;
		public function resolveIDPartToSingleObject(parent:IAutomationObject, part:AutomationIDPart):IAutomationObject;
		public function resolveIDToSingleObject(rid:AutomationID, currentParent:IAutomationObject = null):IAutomationObject;
		public function showInHierarchy(obj:IAutomationObject):Boolean;
	}
}
