package air.update.core {
	import air.update.descriptors.ApplicationDescriptor;
	import air.update.descriptors.UpdateDescriptor;
	import air.update.events.DownloadErrorEvent;
	import air.update.events.StatusFileUpdateErrorEvent;
	import air.update.events.StatusFileUpdateEvent;
	import air.update.events.StatusUpdateErrorEvent;
	import air.update.events.StatusUpdateEvent;
	import air.update.events.UpdateEvent;
	import air.update.logging.Logger;
	import air.update.net.FileDownloader;
	import air.update.states.HSM;
	import air.update.states.HSMEvent;
	import air.update.states.UpdateState;
	import air.update.utils.Constants;
	import air.update.utils.FileUtils;
	import air.update.utils.VersionUtils;
	import flash.events.ErrorEvent;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.ProgressEvent;
	import flash.filesystem.File;
	import flash.net.URLRequest;
	public class UpdaterHSM extends HSM {
		private static var logger:Logger;
		public static const EVENT_CHECK:String="updater.check";
		public static const EVENT_DOWNLOAD:String="updater.download";
		public static const EVENT_INSTALL:String="updater.install";
		public static const EVENT_INSTALL_TRIGGER:String="install.trigger";
		public static const EVENT_FILE_INSTALL_TRIGGER:String="file_install.trigger";
		public static const EVENT_STATE_CLEAR_TRIGGER:String="state_clear.trigger";
		public static const EVENT_ASYNC:String="check.async";
		public static const EVENT_FILE:String="check.file";
		public static const EVENT_VERIFIED:String="check.verified";
		private var downloader:FileDownloader;
		private var descriptorURL:URLRequest;
		private var descriptorFile:File;
		private var updateURL:URLRequest;
		private var updateFile:File;
		private var _descriptor:UpdateDescriptor;
		private var _applicationDescriptor:ApplicationDescriptor;
		private var requestedURL:String;
		private var requestedFile:File;
		private var unpackager:AIRUnpackager;
		private var _configuration:UpdaterConfiguration;
		public function UpdaterHSM();
		public function get configuration():UpdaterConfiguration;
		public function set configuration(value:UpdaterConfiguration):void;
		private function isNewerVersion(oldVersion:String,newVersion:String):Boolean;
		public function checkAsync(url:String):void;
		public function installFile(file:File):void;
		public function cancel():void;
		public function getUpdateState():int;
		public function get descriptor():UpdateDescriptor;
		public function get applicationDescriptor():ApplicationDescriptor;
		public function get airFile():File;
		protected function stateInitialized(event:Event):void;
		protected function stateBeforeChecking(event:Event):void;
		protected function stateChecking(event:Event):void;
		protected function stateAvailable(event:Event):void;
		protected function stateDownloading(event:Event):void;
		protected function stateDownloaded(event:Event):void;
		protected function stateInstalling(event:Event):void;
		protected function statePendingInstall(event:Event):void;
		protected function stateUnpackaging(event:Event):void;
		protected function stateAvailableFile(event:Event):void;
		protected function stateInstallingFile(event:Event):void;
		protected function stateReady(event:Event):void;
		protected function stateCancelled(event:Event):void;
		protected function stateErrored(event:Event):void;
		private function fileUnpackaged():void;
		private function descriptorDownloaded():void;
		private function installUpdate():void;
		private function installFileUpdate():void;
		private function startTimer(delay:Number=-1):void;
	}
}
