package jp.sourceforge.asclipse.as3.resolver;

import jp.sourceforge.asclipse.as3.element.AS3Type;

/**
 * {@link AS3TypeRef}を管理するクラスのインターフェース。
 * @author shin1ogawa
 */
public interface ITypeResolver {

	/**
	 * {@link AS3TypeRef}を作成する。
	 * @param typeName
	 * @return 新しく作成した{@link AS3TypeRef}
	 */
	AS3TypeRef newTypeRef(String typeName);

	/**
	 * {@link AS3TypeRef}を作成する。
	 * @param type
	 * @return 同じ{@AS3Type}を参照する{@AS3TypeRef}があればそれを、
	 * そうでない場合は参照を解決済みの新しく作成した{@link AS3TypeRef}を返す。
	 */
	AS3TypeRef newTypeRef(AS3Type type);

	/**
	 * 指定された{@link AS3Type}を参照する{@link AS3TypeRef}を未解決状態にする。
	 * @param type
	 * @throws NullPointerException {@code type}が{@code null}の時。
	 */
	void unresolve(AS3Type type);

	/**
	 * {@link AS3Type}のインスタンスを入れ替える。
	 * @param oldType
	 * @param newType
	 * @throws NullPointerException {@code oldType}または{@code newType}が{@code null}の時。
	 */
	void updateType(AS3Type oldType, AS3Type newType);

	/**
	 * {@link AS3Type}のインスタンスを削除する。
	 * @param type
	 */
	void removeType(AS3Type type);

	/**
	 * 参照を解決する。
	 * @param typeRef 
	 * @param enclosureType 参照を保持している型。解決する際に、importやパッケージに依存するため必要となる。
	 * @return 解決できた場合は{@code true}、解決できなかった場合は{@code false}
	 */
	boolean resolve(AS3TypeRef typeRef, AS3Type enclosureType);
}
