package jp.sourceforge.asclipse.as3.internal.element;

import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Root;

/**
 * {@link AS3Root}を実装したクラスの内部用のインターフェース
 * @author shin1ogawa
 */
public interface ModifiableAS3Root extends AS3Root {

	/**
	 * 解析中に発生したエラーのリストを設定する。
	 * @param parserErrors {@code null}は許可しない。
	 */
	void setParserErrors(List<Exception> parserErrors);

	/**
	 * 解析中に発生したエラーのリストを追加する。
	 * @param parserErrors {@code null}は許可しない。
	 */
	void addParserErrors(List<Exception> parserErrors);

	/**
	 * リソース名を設定する。
	 * @param resourceName {@code null}は許可しない。
	 */
	void setResourceName(String resourceName);
}
