package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3Element;

/**
 * 内部で使用する、変更を行う操作を公開するためのインターフェース。
 * @author shin1ogawa
 */
public interface ModifiableAS3Element {

	/**
	 * 要素の種類を設定する。
	 * 
	 * @param elementType 要素の種類
	 */
	@Deprecated
	void setElementType(int elementType);

	/**
	 * 子要素を追加する。
	 * @param child 子要素
	 */
	void addChildren(AS3Element child);

	/**
	 * 親要素を設定する。
	 * @param parent
	 */
	void setParent(AS3Element parent);
}
