package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3UseNamespaceDirective;
import jp.sourceforge.asclipse.as3.util.CommonTreeUtil.SerializableToken;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3UseNamespaceDirective}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3UseNamespaceDirective extends AbstractAS3Element implements
		AS3UseNamespaceDirective {

	private final SerializableToken[] identifiers;


	/**
	 * Constructor.
	 * @param tree
	 * @param identifiers
	 * @category constructor
	 */
	public DefaultAS3UseNamespaceDirective(CommonTree tree, CommonTree[] identifiers) {
		super(tree);
		this.identifiers = new SerializableToken[identifiers.length];
		for (int i = 0; i < identifiers.length; i++) {
			this.identifiers[i] = new SerializableToken(identifiers[i].getToken());
		}
	}

	public String getOutlineTitle() {
		return getTitle();
	}

	public String getTitle() {
		StringBuilder b = new StringBuilder("use namespace ");
		boolean first = true;
		for (SerializableToken identifier : identifiers) {
			if (!first) {
				b.append(",");
			} else {
				first = false;
			}
			b.append(identifier.getText());
		}
		return b.toString();
	}
}
