package jp.sourceforge.asclipse.as3.internal.element;

import java.util.Collections;
import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Property;
import jp.sourceforge.asclipse.as3.element.AS3Variable;
import jp.sourceforge.asclipse.as3.util.ModifiersUtil;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Property}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3Property extends AbstractAS3ElementWithModifiers implements AS3Property {

	private final List<AS3Variable> variables;


	/**
	 * Constructor.
	 * @param tree
	 * @param modifiers
	 * @param variables
	 * @category constructor
	 */
	public DefaultAS3Property(CommonTree tree, CommonTree[] modifiers, List<AS3Variable> variables) {
		super(tree, modifiers);
		this.variables = variables;
		if (variables != null) {
			for (AS3Variable variable : variables) {
				addChildren(variable);
			}
		}
	}

	public String getOutlineTitle() {
		StringBuilder b = new StringBuilder();
		if (hasNamespaceModifier()) {
			b.append(getNamespaceModifier().getText()).append(" ");
		}
		boolean first = true;
		for (AS3Variable variable : variables) {
			if (!first) {
				b.append(",");
			} else {
				first = false;
			}
			b.append(variable.getOutlineTitle());
		}
		return b.toString();
	}

	public String getTitle() {
		StringBuilder b = new StringBuilder();
		b.append(ModifiersUtil.getTitle(modifiers));
		b.append(b.length() == 0 ? "" : " ").append("var").append(" ");
		boolean first = true;
		for (AS3Variable variable : variables) {
			if (!first) {
				b.append(",");
			} else {
				first = false;
			}
			b.append(variable.getOutlineTitle());
		}
		return b.toString();
	}

	public List<AS3Variable> getVariables() {
		return Collections.unmodifiableList(variables);
	}
}
