package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3Package;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Package}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3Package extends AbstractAS3Root implements AS3Package {

	private final String identifier;


	/**
	 * Constructor.
	 * @param tree
	 * @param identifier 
	 * @category constructor
	 */
	public DefaultAS3Package(CommonTree tree, String identifier) {
		super(tree);
		this.identifier = identifier;
	}

	public String getOutlineTitle() {
		return getTitle();
	}

	public String getTitle() {
		return "package " + identifier;
	}

	public String getIdentifier() {
		return identifier;
	}

	@Override
	public AS3Package getEnclosurePackage() {
		return this;
	}
}
