package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3NamespaceDirective;
import jp.sourceforge.asclipse.as3.util.ModifiersUtil;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3NamespaceDirective}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3NamespaceDirective extends AbstractAS3ElementWithModifiers implements
		AS3NamespaceDirective {

	private final String identifier;

	private final boolean hasAssignment;

	private final String literal;


	/**
	 * Constructor.
	 * @param tree
	 * @param modifiers
	 * @param identifier
	 * @param hasAssignment
	 * @param literal
	 * @category constructor
	 */
	public DefaultAS3NamespaceDirective(CommonTree tree, CommonTree[] modifiers, String identifier,
			boolean hasAssignment, String literal) {
		super(tree, modifiers);
		this.identifier = identifier;
		this.hasAssignment = hasAssignment;
		this.literal = literal;
	}

	public String getOutlineTitle() {
		return identifier;
	}

	public String getTitle() {
		StringBuilder b = new StringBuilder();
		b.append(ModifiersUtil.getTitle(modifiers));
		b.append(b.length() == 0 ? "" : " ").append("namespace ");
		b.append(identifier);
		if (hasAssignment) {
			b.append("=");
			b.append(literal);
		}
		return b.toString();
	}
}
