package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3Metadata;
import jp.sourceforge.asclipse.as3.util.CommonTreeUtil.SerializableToken;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Metadata}の内部クラス用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3Metadata extends AbstractAS3Element implements AS3Metadata {

	private final String identifier;

	private final SerializableToken[] children;


	/**
	 * Constructor.
	 * @param tree
	 * @param identifier 
	 * @param children
	 * @category constructor
	 */
	public DefaultAS3Metadata(CommonTree tree, String identifier, CommonTree[] children) {
		super(tree);
		this.identifier = identifier;
		this.children = new SerializableToken[children.length];
		for (int i = 0; i < children.length; i++) {
			this.children[i] = new SerializableToken(children[i].getToken());
		}
	}

	public String getOutlineTitle() {
		return getTitle();
	}

	public String getTitle() {
		StringBuilder b = new StringBuilder();
		b.append("[").append(identifier);
		for (SerializableToken tree : children) {
			b.append(tree.getText());
		}
		b.append("]");
		return b.toString();
	}

}
