package jp.sourceforge.asclipse.as3.internal.element;

import java.util.Collections;
import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Interface;
import jp.sourceforge.asclipse.as3.resolver.AS3TypeRef;
import jp.sourceforge.asclipse.as3.util.ModifiersUtil;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Interface}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3Interface extends AbstractAS3Type implements AS3Interface {

	private final List<AS3TypeRef> extendsTypeRefs;


	/**
	 * Constructor.
	 * @param tree
	 * @param modifiers
	 * @param identifier
	 * @param extendsTypeRefs
	 * @category constructor
	 */
	public DefaultAS3Interface(CommonTree tree, CommonTree[] modifiers, String identifier,
			List<AS3TypeRef> extendsTypeRefs) {
		super(tree, modifiers, identifier);
		this.extendsTypeRefs = extendsTypeRefs;
	}

	public String getOutlineTitle() {
		StringBuilder b = new StringBuilder();
		b.append(identifier);
		return b.toString();
	}

	public String getTitle() {
		StringBuilder b = new StringBuilder();
		b.append(ModifiersUtil.getTitle(modifiers));
		b.append(b.length() == 0 ? "" : " ").append("interface ").append(identifier);
		if (!extendsTypeRefs.isEmpty()) {
			b.append(" extends ");
			boolean first = true;
			for (AS3TypeRef typeRef : extendsTypeRefs) {
				if (!first) {
					b.append(", ");
				} else {
					first = false;
				}
				b.append(typeRef.getTypeName());
			}
		}
		return b.toString();
	}

	public List<AS3TypeRef> getExtendsTypeRefs() {
		return Collections.unmodifiableList(extendsTypeRefs);
	}
}
