package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3Include;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Include}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3Include extends AbstractAS3Element implements AS3Include {

	private final String literal;


	/**
	 * Constructor.
	 * @param tree
	 * @param literal 
	 * @category constructor
	 */
	public DefaultAS3Include(CommonTree tree, String literal) {
		super(tree);
		this.literal = literal;
	}

	public String getOutlineTitle() {
		return getTitle();
	}

	public String getTitle() {
		return "include " + literal;
	}
}
