package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3Import;
import jp.sourceforge.asclipse.as3.resolver.AS3TypeRef;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Import}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3Import extends AbstractAS3Element implements AS3Import {

	private final AS3TypeRef typeRef;

	private final boolean isSingleTypeRef;


	/**
	 * Constructor.
	 * @param tree
	 * @param typeRef
	 * @param isSingleTypeRef
	 * @category constructor
	 */
	public DefaultAS3Import(CommonTree tree, AS3TypeRef typeRef, boolean isSingleTypeRef) {
		super(tree);
		this.typeRef = typeRef;
		this.isSingleTypeRef = isSingleTypeRef;
	}

	public String getOutlineTitle() {
		return "import " + typeRef.getTypeName();
	}

	public String getTitle() {
		return "import " + typeRef.getTypeName();
	}

	public boolean isSingleType() {
		return isSingleTypeRef;
	}

	public AS3TypeRef getTypeRef() {
		return typeRef;
	}
}
