package jp.sourceforge.asclipse.as3.internal.element;

import java.util.Collections;
import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3ConstProperty;
import jp.sourceforge.asclipse.as3.element.AS3Variable;
import jp.sourceforge.asclipse.as3.util.ModifiersUtil;

import org.antlr.runtime.tree.CommonTree;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * {@link AS3ConstProperty}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3ConstProperty extends AbstractAS3ElementWithModifiers implements
		AS3ConstProperty {

	@SuppressWarnings("unused")
	private static final Logger LOGGER = LoggerFactory.getLogger(AS3ConstProperty.class);

	private final List<AS3Variable> variables;


	/**
	 * Constructor.
	 * @param tree
	 * @param modifiers
	 * @param variables
	 * @category constructor
	 */
	public DefaultAS3ConstProperty(CommonTree tree, CommonTree[] modifiers,
			List<AS3Variable> variables) {
		super(tree, modifiers);
		this.variables = variables;
		if (variables != null) {
			for (AS3Variable variable : variables) {
				addChildren(variable);
			}
		}
	}

	public String getOutlineTitle() {
		StringBuilder b = new StringBuilder();
		if (hasNamespaceModifier()) {
			b.append(getNamespaceModifier().getText()).append(" ");
		}
		boolean first = true;
		for (AS3Variable variable : variables) {
			if (!first) {
				b.append(", ");
			} else {
				first = false;
			}
			b.append(variable.getOutlineTitle());
		}
		return b.toString();
	}

	public String getTitle() {
		StringBuilder b = new StringBuilder();
		b.append(ModifiersUtil.getTitle(modifiers));
		b.append(b.length() == 0 ? "" : " ").append("const").append(" ");
		b.append(StringUtils.join(getVariableDeclarationTitles(variables), ", "));
		return b.toString();
	}

	private String[] getVariableDeclarationTitles(List<AS3Variable> variables2) {
		String[] titles = new String[variables2.size()];
		int index = 0;
		for (AS3Variable decl : variables2) {
			titles[index++] = decl.getTitle();
		}
		return titles;
	}

	public List<AS3Variable> getVariables() {
		return Collections.unmodifiableList(variables);
	}
}
