package jp.sourceforge.asclipse.as3.internal.element;

import java.util.Collections;
import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Class;
import jp.sourceforge.asclipse.as3.resolver.AS3TypeRef;
import jp.sourceforge.asclipse.as3.util.CommonTreeUtil.SerializableToken;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Class}の内部用の実装。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public class DefaultAS3Class extends AbstractAS3Type implements AS3Class {

	private final AS3TypeRef extendsTypeRef;

	private final List<AS3TypeRef> implementsTypeRefs;


	/**
	 * Constructor.
	 * @param tree
	 * @param modifiers
	 * @param identifier
	 * @param extendsTypeRef
	 * @param implementsTypeRefs
	 * @category constructor
	 */
	public DefaultAS3Class(CommonTree tree, CommonTree[] modifiers, String identifier,
			AS3TypeRef extendsTypeRef, List<AS3TypeRef> implementsTypeRefs) {
		super(tree, modifiers, identifier);
		this.extendsTypeRef = extendsTypeRef;
		this.implementsTypeRefs = implementsTypeRefs;
	}

	public String getOutlineTitle() {
		return identifier;
	}

	public String getTitle() {
		StringBuilder b = new StringBuilder();
		for (SerializableToken modifier : modifiers) {
			b.append(modifier.getText());
		}
		b.append(b.length() == 0 ? "" : " ").append("class ").append(identifier);
		if (getExtendsTypeRef() != AS3TypeRef.NULL_TYPE_REF) {
			b.append(" extends ").append(getExtendsTypeRef().getTypeName());
		}
		if (!getImplementsTypeRefs().isEmpty()) {
			b.append(" implements ");
			boolean first = true;
			for (AS3TypeRef typeRef : getImplementsTypeRefs()) {
				if (!first) {
					b.append(", ");
				} else {
					first = false;
				}
				b.append(typeRef.getTypeName());
			}
		}
		return b.toString();
	}

	public AS3TypeRef getExtendsTypeRef() {
		return extendsTypeRef;
	}

	public List<AS3TypeRef> getImplementsTypeRefs() {
		return Collections.unmodifiableList(implementsTypeRefs);
	}
}
