package jp.sourceforge.asclipse.as3.internal.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Root;

import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3Root}の内部用の抽象クラス。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public abstract class AbstractAS3Root extends AbstractAS3Element implements ModifiableAS3Root {

	private List<Exception> parserErrors = new ArrayList<Exception>(0);

	private String resourceName;


	/**
	 * Constructor.
	 * @param tree
	 * @category constructor
	 */
	public AbstractAS3Root(CommonTree tree) {
		super(tree);
	}

	/**
	 * Constructor.
	 * @param startLine
	 * @param startCharPositionInLine
	 * @param endLine
	 * @param endCharPositionInLine
	 * @category constructor
	 */
	public AbstractAS3Root(int startLine, int startCharPositionInLine, int endLine,
			int endCharPositionInLine) {
		super(startLine, startCharPositionInLine, endLine, endCharPositionInLine);
	}

	public void setParserErrors(List<Exception> parserErrors) {
		if (parserErrors == null) {
			throw new IllegalArgumentException("parserErrors is null.");
		}
		this.parserErrors = parserErrors;
	}

	public void addParserErrors(List<Exception> parserErrors) {
		if (parserErrors == null) {
			throw new IllegalArgumentException("parserErrors is null.");
		}
		this.parserErrors.addAll(parserErrors);
	}

	public List<Exception> getParserErros() {
		return Collections.unmodifiableList(parserErrors);
	}

	public void setResourceName(String resourceName) {
		if (resourceName == null) {
			throw new IllegalArgumentException("resourceName is null.");
		}
		this.resourceName = resourceName;
	}

	public String getResourceName() {
		return resourceName;
	}

	public boolean hasParserError() {
		return !parserErrors.isEmpty();
	}
}
