package jp.sourceforge.asclipse.as3.internal.element;

import jp.sourceforge.asclipse.as3.element.AS3ElementWithModifiers;
import jp.sourceforge.asclipse.as3.util.ModifiersUtil;
import jp.sourceforge.asclipse.as3.util.CommonTreeUtil.SerializableToken;

import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;

/**
 * {@link AS3ElementWithModifiers}の内部用の抽象クラス。
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
public abstract class AbstractAS3ElementWithModifiers extends AbstractAS3Element implements
		AS3ElementWithModifiers {

	protected final SerializableToken[] modifiers;


	/**
	 * Constructor.
	 * @param tree 
	 * @param modifiers
	 * @category constructor
	 */
	public AbstractAS3ElementWithModifiers(CommonTree tree, CommonTree[] modifiers) {
		super(tree);
		this.modifiers = new SerializableToken[modifiers.length];
		for (int i = 0; i < modifiers.length; i++) {
			this.modifiers[i] = new SerializableToken(modifiers[i].getToken());
		}
	}

	public boolean isDynamic() {
		return ModifiersUtil.isDynamic(modifiers);
	}

	public boolean isFinal() {
		return ModifiersUtil.isFinal(modifiers);
	}

	public boolean isInternal() {
		return ModifiersUtil.isInternal(modifiers) || !ModifiersUtil.isPublic(modifiers)
				&& !ModifiersUtil.isPrivate(modifiers) && !ModifiersUtil.isProtected(modifiers);
	}

	public boolean isNative() {
		return ModifiersUtil.isNative(modifiers);
	}

	public boolean isOverride() {
		return ModifiersUtil.isOverride(modifiers);
	}

	public boolean isPrivate() {
		return ModifiersUtil.isPrivate(modifiers);
	}

	public boolean isProtected() {
		return ModifiersUtil.isProtected(modifiers);
	}

	public boolean isPublic() {
		return ModifiersUtil.isPublic(modifiers);
	}

	public boolean isStatic() {
		return ModifiersUtil.isStatic(modifiers);
	}

	public Token getNamespaceModifier() {
		return ModifiersUtil.getNamespaceModifier(modifiers);
	}

	public boolean hasNamespaceModifier() {
		return ModifiersUtil.hasNamespaceModifier(modifiers);
	}
}
