package jp.sourceforge.asclipse.as3.element;

import jp.sourceforge.asclipse.as3.resolver.AS3TypeRef;

/**
 * ActionScript3の要素を表現するインターフェース。
 * 
 * @author shin1ogawa
 */
public interface AS3Variable extends AS3Element {

	/**
	 * @return 代入値を持つなら{@code true}
	 */
	boolean hasAssigment();

	/**
	 * @return variableの型への参照オブジェクト
	 */
	AS3TypeRef getTypeRef();

	/**
	 * @return 識別子
	 */
	String getIdentifier();

	/**
	 * @return 可変長引数として定義されているなら{@code true}
	 */
	boolean hasEllipsis();
}
