package jp.sourceforge.asclipse.as3.element;

import java.util.List;

/**
 * ファイル単位に対応する、ルート要素のためのインターフェース。
 * @author shin1ogawa
 */
public interface AS3Root extends AS3Element {

	/**
	 * @return 解析エラーが発生したなら{@true}
	 */
	boolean hasParserError();

	/**
	 * @return 解析中に発生した解析エラーのリスト。
	 */
	List<Exception> getParserErros();

	/**
	 * @return ファイル名等のリソース名
	 */
	String getResourceName();
}
