package jp.sourceforge.asclipse.as3.element;

import java.util.List;

import jp.sourceforge.asclipse.as3.AS3Lexer;
import jp.sourceforge.asclipse.as3.resolver.AS3TypeRef;

import org.antlr.runtime.Token;

/**
 * interfaceFunctionDeclaration,functionDeclartionに対応する要素。
 * @author shin1ogawa
 */
public interface AS3Function extends AS3Element, AS3ElementWithModifiers {

	/**
	 * @return コンストラクタなら{@code true}
	 */
	boolean isConstructor();

	/**
	 * @return アクセサなら{@code true}
	 */
	boolean isAccessor();

	/**
	 * @return {@link AccessorType}
	 */
	AccessorType getAccessorType();

	/**
	 * @return functionの型への参照オブジェクト
	 */
	AS3TypeRef getTypeRef();

	/**
	 * @return 引数の定義の一覧
	 */
	List<AS3Variable> getParameters();

	/**
	 * @return 識別子
	 */
	String getIdentifier();


	/**
	 * Accessorの種類。
	 * <p>setかgetか。</p>
	 * @author shin1ogawa
	 */
	enum AccessorType {
		GET, SET;

		public static AccessorType valueOf(Token accessorToken) {
			if (accessorToken == null) {
				throw new IllegalArgumentException("accessorToken is null.");
			}
			if (accessorToken.getType() == AS3Lexer.GET) {
				return GET;
			} else if (accessorToken.getType() == AS3Lexer.SET) {
				return SET;
			} else {
				throw new IllegalArgumentException("accessorToken is illegal.");
			}
		}
	}
}
