package jp.sourceforge.asclipse.as3.element;

import org.antlr.runtime.Token;

/**
 * modifierを持つ要素のインターフェース。
 * 
 * @author shin1ogawa
 */
public interface AS3ElementWithModifiers {

	/**
	 * @return {@literal dynamic} modifierを持つなら{@code true}。
	 */
	boolean isDynamic();

	/**
	 * @return {@literal dynamic} modifierを持つなら{@code true}。
	 */
	boolean isFinal();

	/**
	 * @return {@literal internal} modifierを持つなら{@code true}。
	 */
	boolean isInternal();

	/**
	 * @return {@literal native} modifierを持つなら{@code true}。
	 */
	boolean isNative();

	/**
	 * @return {@literal override} modifierを持つなら{@code true}。
	 */
	boolean isOverride();

	/**
	 * @return {@literal private} modifierを持つなら{@code true}。
	 */
	boolean isPrivate();

	/**
	 * @return {@literal protected} modifierを持つなら{@code true}。
	 */
	boolean isProtected();

	/**
	 * @return {@literal public} modifierを持つなら{@code true}。
	 */
	boolean isPublic();

	/**
	 * @return {@literal static} modifierを持つなら{@code true}。
	 */
	boolean isStatic();

	/**
	 * modifiersの中にnamespaceの修飾があるかどうか。
	 * @return namespaceの修飾があるなら{@code true}
	 */
	boolean hasNamespaceModifier();

	/**
	 * @return modifiersの中に含まれるnamespaceの修飾Token。該当するものが無ければ{@code null}を返す。
	 */
	Token getNamespaceModifier();
}
