package jp.sourceforge.asclipse.as3.element;

import java.io.Serializable;
import java.util.List;

import jp.sourceforge.asclipse.as3.adapter.IAS3ElementAdaptable;

/**
 * ActionScript3の要素を表現するインターフェース。
 * 
 * @author shin1ogawa
 */
public interface AS3Element extends IAS3ElementAdaptable, Serializable {

	/**
	 * 要素の種類を返す。
	 * 
	 * @return 要素の種類
	 */
	@Deprecated
	int getElementType();

	/**
	 * ソースコード内での開始行番号を返す。
	 * 
	 * @return ソースコード内での開始行番号
	 */
	int getStartLine();

	/**
	 * ソースコード内の開始行での開始インデックスを返す。
	 * 
	 * @return ソースコード内の開始行での開始インデックス
	 */
	int getCharPositionInLine();

	/**
	 * ソースコード内での終了行番号を返す。
	 * 
	 * @return ソースコード内での終了行番号
	 */
	int getEndLine();

	/**
	 * ソースコード内の終了行での終了インデックスを返す。
	 * 
	 * @return ソースコード内の終了行での終了インデックス
	 */
	int getEndCharPositionInLine();

	/**
	 * 子要素の数を返す。
	 * 
	 * @return 子要素の数。
	 */
	int getChildCount();

	/**
	 * 人間が見てわかる表現にした文字列を返す。
	 * 
	 * @return 人間が見てわかる表現にした文字列
	 */
	String getTitle();

	/**
	 * @return Eclipse上でOutlineに表示するための文字列
	 */
	String getOutlineTitle();

	/**
	 * 子要素のリストを返す。
	 * 
	 * @return 子要素のリスト。子要素が無い場合はサイズ0のリスト。
	 */
	List<AS3Element> getChildren();

	/**
	 * 親のAS3Elementを返す。
	 * @return 親Element
	 */
	AS3Element getParent();

	/**
	 * 構造を破棄し、使用不能にする。
	 */
	void dispose();

	/**
	 * @return 自身を含んでいる{@link AS3Type}
	 */
	AS3Type getEnclosureType();

	/**
	 * @return 自身を含んでいる{@link AS3Package}
	 */
	AS3Package getEnclosurePackage();
}
