package jp.sourceforge.asclipse.as3.adapter;

import jp.sourceforge.asclipse.as3.element.AS3Element;

/**
 * {@link AS3Element}を拡張するためのインターフェース。
 * @author shin1ogawa
 */
public interface IAS3ElementAdaptable {

	/**
	 * @param clazz
	 * @return 指定された拡張を保持しているか。
	 */
	boolean hasAdapter(Class<?> clazz);

	/**
	 * 拡張を取得する。
	 * @param <T>
	 * @param clazz
	 * @return 拡張オブジェクト
	 */
	<T>T getAdapter(Class<T> clazz);

	/**
	 * 拡張を追加する。
	 * @param adapter
	 */
	void addAdapter(IAS3ElementAdapter adapter);
}
