package jp.sourceforge.asclipse.as3.adapter;

import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Element;

/**
 * テキスト内の位置から{@link AS3Element}を探す拡張。
 * @author shin1ogawa
 */
public class GetElementAt extends AbstractAS3ElementAdapter {

	/**
	 * 指定の位置を含む、一番階層が深い{@link AS3Element}を返す。
	 * @param line
	 * @param charPositionInLine
	 * @return 指定のoffsetを含む、一番階層が深い{@link AS3Element}。<br />
	 * 	範囲外だったり、保持するelementがdispose()されていた場合は{@code null}を返す。
	 */
	public AS3Element getElementAt(int line, int charPositionInLine) {
		if (!isConnect() || isEnqueued()) {
			return null;
		}
		return findByPos(getElement(), line, charPositionInLine);
	}

	private static AS3Element findByPos(AS3Element element, int line, int charPositionInLine) {
		if (element.getStartLine() > line || line > element.getEndLine()) {
			return null;
		}
		if (element.getEndLine() == line && element.getEndCharPositionInLine() < charPositionInLine) {
			return null;
		}
		int childCount = element.getChildCount();
		if (childCount == 0) {
			return element;
		}
		List<AS3Element> children = element.getChildren();
		AS3Element elementAt = element;
		for (AS3Element child : children) {
			AS3Element findByPos = findByPos(child, line, charPositionInLine);
			if (findByPos != null) { // && new ElementPosComparator().compare(elementAt, findByPos) > 0) {
				elementAt = findByPos;
			}
		}
		return elementAt;
	}
}
