package jp.sourceforge.asclipse.as3.adapter;

import java.lang.ref.WeakReference;

import jp.sourceforge.asclipse.as3.element.AS3Element;


/**
 * {@link IAS3ElementAdapter}を実装するための抽象クラス。
 * @author shin1ogawa
 */
public abstract class AbstractAS3ElementAdapter implements IAS3ElementAdapter {

	private WeakReference<AS3Element> elementRef;


	public void connect(AS3Element element) {
		this.elementRef = new WeakReference<AS3Element>(element);
	}

	public void disconnect() {
		this.elementRef = null;
	}

	protected AS3Element getElement() {
		return elementRef.get();
	}

	protected boolean isConnect() {
		return elementRef.get() != null;
	}

	/**
	 * @return see {@link WeakReference#isEnqueued()}
	 */
	protected boolean isEnqueued() {
		return elementRef.isEnqueued();
	}
}
