package jp.sourceforge.asclipse.as3;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Root;
import jp.sourceforge.asclipse.as3.element.AS3Type;
import jp.sourceforge.asclipse.as3.resolver.AS3TypeRef;
import jp.sourceforge.asclipse.as3.resolver.ITypeResolver;

/**
 * プロジェクト内で使用する全ての{@link IAS3Context}を保持する。
 * @author shin1ogawa
 */
public interface IAS3GlobalContext {

	/**
	 * {@link IAS3Context}を追加する。
	 * @param context
	 */
	void addContext(IAS3Context context);

	/**
	 * {@link IAS3Context}を削除する。
	 * @param context
	 */
	void removeContext(IAS3Context context);

	/**
	 * 未解決の参照を解決する。
	 * @param typeRef
	 * @param enclosureType 指定したAS3TypeRefを含んでいるAS3Type
	 * @return 解決できなければ{@code false}
	 */
	boolean resolve(AS3TypeRef typeRef, AS3Type enclosureType);

	/**
	 * @param packageName
	 * @return 指定されたパッケージに存在する全ての型
	 */
	List<AS3Type> getTypesInPackage(String packageName);

	/**
	 * 指定された型名に一致する{@link AS3Type}を返す。
	 * @param qualifiedName
	 * @return 指定された型名に一致する{@link AS3Type}
	 */
	AS3Type getTypeElement(String qualifiedName);

	/**
	 * @return 保持している{@link IAS3Context}内から、全ての型を返す。
	 */
	Collection<AS3Type> getAllTypes();

	/**
	 * @return 保持している{@link IAS3Context}内から、全ての{@link AS3Root}を返す。
	 */
	Collection<AS3Root> getAS3Roots();

	/**
	 * @return 保持している{@link IAS3Context}のリスト
	 */
	List<IAS3Context> getContexts();

	/**
	 * @return {@link ITypeResolver}
	 */
	ITypeResolver getTypeResolver();

	/**
	 * ビルトインクラス類を取り込む。
	 * @param name {@literal "/builtin.ser"}を指定する事。現在はビルトインとして複数のAS3バージョンを選べる場合等に使用する予定。
	 * @return ビルトインクラス類を解析した状態の{@link IAS3Context}
	 * @throws IOException
	 * @throws ClassNotFoundException
	 * @see #DEFAULT_BUILTIN 
	 */
	IAS3Context loadBuiltin(String name) throws IOException, ClassNotFoundException;

	/**
	 * @param name {@link IAS3Context}のコンストラクタで使用したルートフォルダ名
	 * @return ルートフォルダに対応する{@link IAS3Context}。見つからなければ{@code null}
	 */
	IAS3Context getContext(String name);


	/** {@link #loadBuiltin(String)}で使用するデフォルトのビルトインクラス群 */
	String DEFAULT_BUILTIN = "/builtin.ser";
}
