/*
License:
  Currently there's no license restriction.You could use,modify it as you like.:)

  See /AS3_ex.g3.original
*/

grammar AS3;

options {
    backtrack=true;
    output=AST;
}

tokens {
	AS          =   'as';
	BREAK       =   'break';
	CASE        =   'case';
	CATCH       =   'catch';
	CLASS       =   'class';
	CONST       =   'const';
	CONTINUE    =   'continue';
	DEFAULT     =   'default';
	DELETE      =   'delete';
	DO          =   'do';
	ELSE        =   'else';
	EXTENDS     =   'extends';
	FALSE       =   'false';
	FINALLY     =   'finally';
	FOR         =   'for';
	FUNCTION    =   'function';
	IF          =   'if';
	IMPLEMENTS  =   'implements';
	IMPORT      =   'import';
	IN          =   'in';
	INSTANCEOF  =   'instanceof';
	INTERFACE   =   'interface';
	INTERNAL    =   'internal';
	IS          =   'is';
	NATIVE      =   'native';
	NEW         =   'new';
	NULL        =   'null';
	PACKAGE     =   'package';  
	PRIVATE     =   'private';
	PROTECTED   =   'protected';
	PUBLIC      =   'public';
	RETURN      =   'return';
	SUPER       =   'super';
	SWITCH      =   'switch';
	THIS        =   'this';
	THROW       =   'throw';
	TO          =   'to';
	TRUE        =   'true';
	TRY         =   'try';
	TYPEOF      =   'typeof';
	USE         =   'use';
	VAR         =   'var';
	VOID        =   'void';
	WHILE       =   'while';
	WITH        =   'with';
	
// KEYWORDs but can be identifier
	EACH        =   'each';
	GET         =   'get';
	SET         =   'set';
	NAMESPACE   =   'namespace';
	INCLUDE     =   'include';
	DYNAMIC     =   'dynamic';
	FINAL       =   'final';
	OVERRIDE    =   'override';
	STATIC      =   'static';
	
// Future KEYWORDS
	//ABSTRACT    =   'abstract';
	//BOOLEAN     =   'boolean';
	//BYTE        =   'byte';
	//CAST        =   'cast';
	//CHAR        =   'char';
	//DEBUGGER    =   'debugger';
	//DOUBLE      =   'double';
	//ENUM        =   'enum';
	//EXPORT      =   'export';
	//FLOAT       =   'float';
	//GOTO        =   'goto';
	//INTRINSIC   =   'intrinsic';
	//LONG        =   'long';
	//PROTOTYPE   =   'prototype';
	//SHORT       =   'short';
	//SYNCHRONIZED=   'synchronized';
	//THROWS      =   'throws';
	//TO          =   'to';
	//TRANSIENT   =   'transient';
	//TYPE        =   'type';
	//VIRTUAL     =   'virtual';
	//VOLATILE    =   'volatile';
	
	SEMI        = ';' ;
	LCURLY      = '{' ;
	RCURLY      = '}' ;
	LPAREN      = '(' ;
	RPAREN      = ')' ;
	LBRACK      = '[' ;
	RBRACK      = ']' ;
	DOT         = '.' ;
	COMMA       = ',' ;
	LT          = '<' ;
	GT          = '>' ;
	LTE         = '<=' ;
	GTE; //         = '>=' ;
	EQ          = '==' ;
	NEQ         = '!=' ;
	SAME        = '===' ;
	NSAME       = '!==' ;
	PLUS        = '+' ;
	SUB         = '-' ;
	STAR        = '*' ;
	DIV         = '/' ; 
	MOD         = '%' ;
	INC         = '++' ;
	DEC         = '--' ;
	SHL         = '<<' ;
	SHR         = '>>' ;
	SHU         = '>>>' ;
	AND         = '&' ;
	OR          = '|' ;
	XOR         = '^' ;
	NOT         = '!' ;
	INV         = '~' ;
	LAND        = '&&' ;
	LOR         = '||' ;
	QUE         = '?' ;
	COLON       = ':' ;
	ASSIGN      = '=' ;
	UNDERSCORE  = '_';
	DOLLAR      = '$';
	MUL_ASSIGN  = '*=' ;
	DIV_ASSIGN  = '/=' ;
	MOD_ASSIGN  = '%=' ;
	ADD_ASSIGN  = '+=' ;
	SUB_ASSIGN  = '-=' ;
	SHL_ASSIGN  = '<<=';
	SHR_ASSIGN  = '>>=';
	SHU_ASSIGN  = '>>>=';
	AND_ASSIGN  = '&=' ;
	XOR_ASSIGN  = '^=' ;
	OR_ASSIGN   = '|=' ;
	ELLIPSIS    = '...';
	XML_ELLIPSIS='..';
	XML_TEND    = '/>';
	XML_E_TEND  = '</';
	XML_NS_OP   = '::';
	XML_AT      = '@';
	XML_LS_STD  = '<>';
	XML_LS_END  = '</>';
}
@header{
package jp.sourceforge.asclipse.as3;

import java.util.ArrayList;

}
@lexer::header {
package jp.sourceforge.asclipse.as3;

}
@lexer::members {

	/**  */
	private Token lastDefaultCnlToken = null;

	// override
	public Token nextToken() {
		Token result = super.nextToken();
		if (result != null && result.getType() != WHITESPACE) {
			lastDefaultCnlToken = result;
		}
		return result;
	}

	public void reset() {
		super.reset(); // reset all recognizer state variables
		if (input instanceof ANTLRStringStream) {
			((ANTLRStringStream) input).reset();
		}
	}

	// TODO: fix this so that regular expression embedded within xml text will
	// work
	private final boolean isRegularExpression() {
		if (lastDefaultCnlToken != null) {
			switch (lastDefaultCnlToken.getType()) {
			case NULL:
			case TRUE:
			case FALSE:
			case THIS:
			case SUPER:
			case IDENTIFIER:
			case HEX_NUMBER_LITERAL:
			case DEC_NUMBER_LITERAL:
			case SINGLE_QUOTE_LITERAL:
			case DOUBLE_QUOTE_LITERAL:
			case RCURLY:
			case RBRACK:
			case RPAREN:
				return false;
			default:
				break;
			}
		}

		// start to predict if the next is a regular expression
		int next = -1;
		int index = 1;
		boolean success = false;
		if ((next = input.LA(index)) != '/') {
			success = false;
			return success;
		}
		index++;
		// check the first regular character
		next = input.LA(index);
		if (next == '\r' || next == '\n' || next == '*' || next == '/'
				|| next == '>') {
			success = false;
			return success;
		} else if (next == '\\') {
			next = input.LA(index + 1);
			if (next == '\r' || next == '\n') {
				success = false;
				return success;
			}
			// we omit the escape sequence \ u XXXX or \ x XX
			index++;
		}
		index++;
		// check the body of regular character
		while ((next = input.LA(index)) != -1) {
			// System.out.println("char["+index+"] = ("+(char)next+")");
			switch (next) {
			case '\r':
			case '\n':
				success = false;
				return success;
			case '\\':
				next = input.LA(index + 1);
				if (next == '\r' || next == '\n') {
					success = false;
					return success;
				}
				// we omit the escape sequence \ u XXXX or \ x XX
				index++;
				break;
			case '/':
				success = true;
				return success;
			}
			index++;
		}
		return success;
	}

	/**
	 * <pre>
	 * judge if is a XMLName
	 * </pre>
	 * 
	 * @param ch
	 *            character
	 * @return if is a XMLName return true
	 */
	static final boolean isXMLText(int ch) {
		return (ch != '{' && ch != '<' && !(isUnicodeIdentifierPart(ch)));
	}

	/*---------------------------UNICODE_INDENTIFER START------------------------------------------*/
	private static final boolean isUnicodeIdentifierPart(int ch) {
		return ch == '$' || ch == '_' || isUnicodeLetter(ch)
				|| isUnicodeDigit(ch) || isUnicodeCombiningMark(ch)
				|| isUnicodeConnectorPunctuation(ch);
	}

	private final void consumeIdentifierUnicodeStart()
			throws RecognitionException, NoViableAltException {
		int ch = input.LA(1);
		if (isUnicodeLetter(ch) || ch == '$' || ch == '_') {
			matchAny();
			do {
				ch = input.LA(1);
				if (isUnicodeIdentifierPart(ch)) {
					mIDENT_PART();
				} else {
					return;
				}
			} while (true);
		} else {
			throw new NoViableAltException();
		}
	}

	/*---------------------------UNICODE_INDENTIFER END------------------------------------------*/

	private static boolean isUnicodeLetter(int ch) {
		return (ch >= '\u0041' && ch <= '\u005A')
				|| (ch >= '\u0061' && ch <= '\u007A') || (ch == '\u00AA')
				|| (ch == '\u00B5') || (ch == '\u00BA')
				|| (ch >= '\u00C0' && ch <= '\u00D6')
				|| (ch >= '\u00D8' && ch <= '\u00F6')
				|| (ch >= '\u00F8' && ch <= '\u02C1')
				|| (ch >= '\u02C6' && ch <= '\u02D1')
				|| (ch >= '\u02E0' && ch <= '\u02E4') || (ch == '\u02EC')
				|| (ch == '\u02EE') || (ch >= '\u0370' && ch <= '\u0374')
				|| (ch >= '\u0376' && ch <= '\u037D') || (ch == '\u0386')
				|| (ch >= '\u0388' && ch <= '\u03F5')
				|| (ch >= '\u03F7' && ch <= '\u0481')
				|| (ch >= '\u048A' && ch <= '\u0559')
				|| (ch >= '\u0561' && ch <= '\u0587')
				|| (ch >= '\u05D0' && ch <= '\u05F2')
				|| (ch >= '\u0621' && ch <= '\u064A')
				|| (ch >= '\u066E' && ch <= '\u066F')
				|| (ch >= '\u0671' && ch <= '\u06D3') || (ch == '\u06D5')
				|| (ch >= '\u06E5' && ch <= '\u06E6')
				|| (ch >= '\u06EE' && ch <= '\u06EF')
				|| (ch >= '\u06FA' && ch <= '\u06FC') || (ch == '\u06FF')
				|| (ch == '\u0710') || (ch >= '\u0712' && ch <= '\u072F')
				|| (ch >= '\u074D' && ch <= '\u07A5') || (ch == '\u07B1')
				|| (ch >= '\u07CA' && ch <= '\u07EA')
				|| (ch >= '\u07F4' && ch <= '\u07F5') || (ch == '\u07FA')
				|| (ch >= '\u0904' && ch <= '\u0939') || (ch == '\u093D')
				|| (ch == '\u0950') || (ch >= '\u0958' && ch <= '\u0961')
				|| (ch >= '\u0971' && ch <= '\u097F')
				|| (ch >= '\u0985' && ch <= '\u09B9') || (ch == '\u09BD')
				|| (ch == '\u09CE') || (ch >= '\u09DC' && ch <= '\u09E1')
				|| (ch >= '\u09F0' && ch <= '\u09F1')
				|| (ch >= '\u0A05' && ch <= '\u0A39')
				|| (ch >= '\u0A59' && ch <= '\u0A5E')
				|| (ch >= '\u0A72' && ch <= '\u0A74')
				|| (ch >= '\u0A85' && ch <= '\u0AB9') || (ch == '\u0ABD')
				|| (ch >= '\u0AD0' && ch <= '\u0AE1')
				|| (ch >= '\u0B05' && ch <= '\u0B39') || (ch == '\u0B3D')
				|| (ch >= '\u0B5C' && ch <= '\u0B61') || (ch == '\u0B71')
				|| (ch >= '\u0B83' && ch <= '\u0BB9') || (ch == '\u0BD0')
				|| (ch >= '\u0C05' && ch <= '\u0C3D')
				|| (ch >= '\u0C58' && ch <= '\u0C61')
				|| (ch >= '\u0C85' && ch <= '\u0CB9') || (ch == '\u0CBD')
				|| (ch >= '\u0CDE' && ch <= '\u0CE1')
				|| (ch >= '\u0D05' && ch <= '\u0D3D')
				|| (ch >= '\u0D60' && ch <= '\u0D61')
				|| (ch >= '\u0D7A' && ch <= '\u0D7F')
				|| (ch >= '\u0D85' && ch <= '\u0DC6')
				|| (ch >= '\u0E01' && ch <= '\u0E30')
				|| (ch >= '\u0E32' && ch <= '\u0E33')
				|| (ch >= '\u0E40' && ch <= '\u0E46')
				|| (ch >= '\u0E81' && ch <= '\u0EB0')
				|| (ch >= '\u0EB2' && ch <= '\u0EB3')
				|| (ch >= '\u0EBD' && ch <= '\u0EC6')
				|| (ch >= '\u0EDC' && ch <= '\u0F00')
				|| (ch >= '\u0F40' && ch <= '\u0F6C')
				|| (ch >= '\u0F88' && ch <= '\u0F8B')
				|| (ch >= '\u1000' && ch <= '\u102A') || (ch == '\u103F')
				|| (ch >= '\u1050' && ch <= '\u1055')
				|| (ch >= '\u105A' && ch <= '\u105D') || (ch == '\u1061')
				|| (ch >= '\u1065' && ch <= '\u1066')
				|| (ch >= '\u106E' && ch <= '\u1070')
				|| (ch >= '\u1075' && ch <= '\u1081') || (ch == '\u108E')
				|| (ch >= '\u10A0' && ch <= '\u10FA')
				|| (ch >= '\u10FC' && ch <= '\u135A')
				|| (ch >= '\u1380' && ch <= '\u138F')
				|| (ch >= '\u13A0' && ch <= '\u166C')
				|| (ch >= '\u166F' && ch <= '\u1676')
				|| (ch >= '\u1681' && ch <= '\u169A')
				|| (ch >= '\u16A0' && ch <= '\u16EA')
				|| (ch >= '\u16EE' && ch <= '\u1711')
				|| (ch >= '\u1720' && ch <= '\u1731')
				|| (ch >= '\u1740' && ch <= '\u1751')
				|| (ch >= '\u1760' && ch <= '\u1770')
				|| (ch >= '\u1780' && ch <= '\u17B3') || (ch == '\u17D7')
				|| (ch == '\u17DC') || (ch >= '\u1820' && ch <= '\u18A8')
				|| (ch >= '\u18AA' && ch <= '\u191C')
				|| (ch >= '\u1950' && ch <= '\u19A9')
				|| (ch >= '\u19C1' && ch <= '\u19C7')
				|| (ch >= '\u1A00' && ch <= '\u1A16')
				|| (ch >= '\u1B05' && ch <= '\u1B33')
				|| (ch >= '\u1B45' && ch <= '\u1B4B')
				|| (ch >= '\u1B83' && ch <= '\u1BA0')
				|| (ch >= '\u1BAE' && ch <= '\u1BAF')
				|| (ch >= '\u1C00' && ch <= '\u1C23')
				|| (ch >= '\u1C4D' && ch <= '\u1C4F')
				|| (ch >= '\u1C5A' && ch <= '\u1C7D')
				|| (ch >= '\u1D00' && ch <= '\u1DBF')
				|| (ch >= '\u1E00' && ch <= '\u1FBC') || (ch == '\u1FBE')
				|| (ch >= '\u1FC2' && ch <= '\u1FCC')
				|| (ch >= '\u1FD0' && ch <= '\u1FDB')
				|| (ch >= '\u1FE0' && ch <= '\u1FEC')
				|| (ch >= '\u1FF2' && ch <= '\u1FFC') || (ch == '\u2071')
				|| (ch == '\u207F') || (ch >= '\u2090' && ch <= '\u2094')
				|| (ch == '\u2102') || (ch == '\u2107')
				|| (ch >= '\u210A' && ch <= '\u2113') || (ch == '\u2115')
				|| (ch >= '\u2119' && ch <= '\u211D') || (ch == '\u2124')
				|| (ch == '\u2126') || (ch == '\u2128')
				|| (ch >= '\u212A' && ch <= '\u212D')
				|| (ch >= '\u212F' && ch <= '\u2139')
				|| (ch >= '\u213C' && ch <= '\u213F')
				|| (ch >= '\u2145' && ch <= '\u2149') || (ch == '\u214E')
				|| (ch >= '\u2160' && ch <= '\u2188')
				|| (ch >= '\u2C00' && ch <= '\u2CE4')
				|| (ch >= '\u2D00' && ch <= '\u2DDE') || (ch == '\u2E2F')
				|| (ch >= '\u3005' && ch <= '\u3007')
				|| (ch >= '\u3021' && ch <= '\u3029')
				|| (ch >= '\u3031' && ch <= '\u3035')
				|| (ch >= '\u3038' && ch <= '\u303C')
				|| (ch >= '\u3041' && ch <= '\u3096')
				|| (ch >= '\u309D' && ch <= '\u309F')
				|| (ch >= '\u30A1' && ch <= '\u30FA')
				|| (ch >= '\u30FC' && ch <= '\u318E')
				|| (ch >= '\u31A0' && ch <= '\u31B7')
				|| (ch >= '\u31F0' && ch <= '\u31FF')
				|| (ch >= '\u3400' && ch <= '\u4DB5')
				|| (ch >= '\u4E00' && ch <= '\uA48C')
				|| (ch >= '\uA500' && ch <= '\uA60C')
				|| (ch >= '\uA610' && ch <= '\uA61F')
				|| (ch >= '\uA62A' && ch <= '\uA66E')
				|| (ch >= '\uA67F' && ch <= '\uA697')
				|| (ch >= '\uA717' && ch <= '\uA71F')
				|| (ch >= '\uA722' && ch <= '\uA788')
				|| (ch >= '\uA78B' && ch <= '\uA801')
				|| (ch >= '\uA803' && ch <= '\uA805')
				|| (ch >= '\uA807' && ch <= '\uA80A')
				|| (ch >= '\uA80C' && ch <= '\uA822')
				|| (ch >= '\uA840' && ch <= '\uA873')
				|| (ch >= '\uA882' && ch <= '\uA8B3')
				|| (ch >= '\uA90A' && ch <= '\uA925')
				|| (ch >= '\uA930' && ch <= '\uA946')
				|| (ch >= '\uAA00' && ch <= '\uAA28')
				|| (ch >= '\uAA40' && ch <= '\uAA42')
				|| (ch >= '\uAA44' && ch <= '\uAA4B')
				|| (ch >= '\uAC00' && ch <= '\uD7A3')
				|| (ch >= '\uF900' && ch <= '\uFB1D')
				|| (ch >= '\uFB1F' && ch <= '\uFB28')
				|| (ch >= '\uFB2A' && ch <= '\uFD3D')
				|| (ch >= '\uFD50' && ch <= '\uFDFB')
				|| (ch >= '\uFE70' && ch <= '\uFEFC')
				|| (ch >= '\uFF21' && ch <= '\uFF3A')
				|| (ch >= '\uFF41' && ch <= '\uFF5A')
				|| (ch >= '\uFF66' && ch <= '\uFFDC');
	}

	private static boolean isUnicodeCombiningMark(int ch) {
		return (ch >= '\u0300' && ch <= '\u036F')
				|| (ch >= '\u0483' && ch <= '\u0487')
				|| (ch >= '\u0591' && ch <= '\u05BD') || (ch == '\u05BF')
				|| (ch >= '\u05C1' && ch <= '\u05C2')
				|| (ch >= '\u05C4' && ch <= '\u05C5') || (ch == '\u05C7')
				|| (ch >= '\u0610' && ch <= '\u061A')
				|| (ch >= '\u064B' && ch <= '\u065E') || (ch == '\u0670')
				|| (ch >= '\u06D6' && ch <= '\u06DC')
				|| (ch >= '\u06DF' && ch <= '\u06E4')
				|| (ch >= '\u06E7' && ch <= '\u06E8')
				|| (ch >= '\u06EA' && ch <= '\u06ED') || (ch == '\u0711')
				|| (ch >= '\u0730' && ch <= '\u074A')
				|| (ch >= '\u07A6' && ch <= '\u07B0')
				|| (ch >= '\u07EB' && ch <= '\u07F3')
				|| (ch >= '\u0901' && ch <= '\u0903') || (ch == '\u093C')
				|| (ch >= '\u093E' && ch <= '\u094D')
				|| (ch >= '\u0951' && ch <= '\u0954')
				|| (ch >= '\u0962' && ch <= '\u0963')
				|| (ch >= '\u0981' && ch <= '\u0983') || (ch == '\u09BC')
				|| (ch >= '\u09BE' && ch <= '\u09CD') || (ch == '\u09D7')
				|| (ch >= '\u09E2' && ch <= '\u09E3')
				|| (ch >= '\u0A01' && ch <= '\u0A03')
				|| (ch >= '\u0A3C' && ch <= '\u0A51')
				|| (ch >= '\u0A70' && ch <= '\u0A71')
				|| (ch >= '\u0A75' && ch <= '\u0A83') || (ch == '\u0ABC')
				|| (ch >= '\u0ABE' && ch <= '\u0ACD')
				|| (ch >= '\u0AE2' && ch <= '\u0AE3')
				|| (ch >= '\u0B01' && ch <= '\u0B03') || (ch == '\u0B3C')
				|| (ch >= '\u0B3E' && ch <= '\u0B57')
				|| (ch >= '\u0B62' && ch <= '\u0B63') || (ch == '\u0B82')
				|| (ch >= '\u0BBE' && ch <= '\u0BCD') || (ch == '\u0BD7')
				|| (ch >= '\u0C01' && ch <= '\u0C03')
				|| (ch >= '\u0C3E' && ch <= '\u0C56')
				|| (ch >= '\u0C62' && ch <= '\u0C63')
				|| (ch >= '\u0C82' && ch <= '\u0C83') || (ch == '\u0CBC')
				|| (ch >= '\u0CBE' && ch <= '\u0CD6')
				|| (ch >= '\u0CE2' && ch <= '\u0CE3')
				|| (ch >= '\u0D02' && ch <= '\u0D03')
				|| (ch >= '\u0D3E' && ch <= '\u0D57')
				|| (ch >= '\u0D62' && ch <= '\u0D63')
				|| (ch >= '\u0D82' && ch <= '\u0D83')
				|| (ch >= '\u0DCA' && ch <= '\u0DF3') || (ch == '\u0E31')
				|| (ch >= '\u0E34' && ch <= '\u0E3A')
				|| (ch >= '\u0E47' && ch <= '\u0E4E') || (ch == '\u0EB1')
				|| (ch >= '\u0EB4' && ch <= '\u0EBC')
				|| (ch >= '\u0EC8' && ch <= '\u0ECD')
				|| (ch >= '\u0F18' && ch <= '\u0F19') || (ch == '\u0F35')
				|| (ch == '\u0F37') || (ch == '\u0F39')
				|| (ch >= '\u0F3E' && ch <= '\u0F3F')
				|| (ch >= '\u0F71' && ch <= '\u0F84')
				|| (ch >= '\u0F86' && ch <= '\u0F87')
				|| (ch >= '\u0F90' && ch <= '\u0FBC') || (ch == '\u0FC6')
				|| (ch >= '\u102B' && ch <= '\u103E')
				|| (ch >= '\u1056' && ch <= '\u1059')
				|| (ch >= '\u105E' && ch <= '\u1060')
				|| (ch >= '\u1062' && ch <= '\u1064')
				|| (ch >= '\u1067' && ch <= '\u106D')
				|| (ch >= '\u1071' && ch <= '\u1074')
				|| (ch >= '\u1082' && ch <= '\u108D') || (ch == '\u108F')
				|| (ch == '\u135F') || (ch >= '\u1712' && ch <= '\u1714')
				|| (ch >= '\u1732' && ch <= '\u1734')
				|| (ch >= '\u1752' && ch <= '\u1753')
				|| (ch >= '\u1772' && ch <= '\u1773')
				|| (ch >= '\u17B6' && ch <= '\u17D3') || (ch == '\u17DD')
				|| (ch >= '\u180B' && ch <= '\u180D') || (ch == '\u18A9')
				|| (ch >= '\u1920' && ch <= '\u193B')
				|| (ch >= '\u19B0' && ch <= '\u19C0')
				|| (ch >= '\u19C8' && ch <= '\u19C9')
				|| (ch >= '\u1A17' && ch <= '\u1A1B')
				|| (ch >= '\u1B00' && ch <= '\u1B04')
				|| (ch >= '\u1B34' && ch <= '\u1B44')
				|| (ch >= '\u1B6B' && ch <= '\u1B73')
				|| (ch >= '\u1B80' && ch <= '\u1B82')
				|| (ch >= '\u1BA1' && ch <= '\u1BAA')
				|| (ch >= '\u1C24' && ch <= '\u1C37')
				|| (ch >= '\u1DC0' && ch <= '\u1DFF')
				|| (ch >= '\u20D0' && ch <= '\u20DC') || (ch == '\u20E1')
				|| (ch >= '\u20E5' && ch <= '\u20F0')
				|| (ch >= '\u2DE0' && ch <= '\u2DFF')
				|| (ch >= '\u302A' && ch <= '\u302F')
				|| (ch >= '\u3099' && ch <= '\u309A') || (ch == '\uA66F')
				|| (ch >= '\uA67C' && ch <= '\uA67D') || (ch == '\uA802')
				|| (ch == '\uA806') || (ch == '\uA80B')
				|| (ch >= '\uA823' && ch <= '\uA827')
				|| (ch >= '\uA880' && ch <= '\uA881')
				|| (ch >= '\uA8B4' && ch <= '\uA8C4')
				|| (ch >= '\uA926' && ch <= '\uA92D')
				|| (ch >= '\uA947' && ch <= '\uA953')
				|| (ch >= '\uAA29' && ch <= '\uAA36') || (ch == '\uAA43')
				|| (ch >= '\uAA4C' && ch <= '\uAA4D') || (ch == '\uFB1E')
				|| (ch >= '\uFE00' && ch <= '\uFE0F')
				|| (ch >= '\uFE20' && ch <= '\uFE26');
	}

	private static boolean isUnicodeDigit(int ch) {
		return (ch >= '\u0030' && ch <= '\u0039')
				|| (ch >= '\u0660' && ch <= '\u0669')
				|| (ch >= '\u06F0' && ch <= '\u06F9')
				|| (ch >= '\u07C0' && ch <= '\u07C9')
				|| (ch >= '\u0966' && ch <= '\u096F')
				|| (ch >= '\u09E6' && ch <= '\u09EF')
				|| (ch >= '\u0A66' && ch <= '\u0A6F')
				|| (ch >= '\u0AE6' && ch <= '\u0AEF')
				|| (ch >= '\u0B66' && ch <= '\u0B6F')
				|| (ch >= '\u0BE6' && ch <= '\u0BEF')
				|| (ch >= '\u0C66' && ch <= '\u0C6F')
				|| (ch >= '\u0CE6' && ch <= '\u0CEF')
				|| (ch >= '\u0D66' && ch <= '\u0D6F')
				|| (ch >= '\u0E50' && ch <= '\u0E59')
				|| (ch >= '\u0ED0' && ch <= '\u0ED9')
				|| (ch >= '\u0F20' && ch <= '\u0F29')
				|| (ch >= '\u1040' && ch <= '\u1049')
				|| (ch >= '\u1090' && ch <= '\u1099')
				|| (ch >= '\u17E0' && ch <= '\u17E9')
				|| (ch >= '\u1810' && ch <= '\u1819')
				|| (ch >= '\u1946' && ch <= '\u194F')
				|| (ch >= '\u19D0' && ch <= '\u19D9')
				|| (ch >= '\u1B50' && ch <= '\u1B59')
				|| (ch >= '\u1BB0' && ch <= '\u1BB9')
				|| (ch >= '\u1C40' && ch <= '\u1C49')
				|| (ch >= '\u1C50' && ch <= '\u1C59')
				|| (ch >= '\uA620' && ch <= '\uA629')
				|| (ch >= '\uA8D0' && ch <= '\uA909')
				|| (ch >= '\uAA50' && ch <= '\uAA59')
				|| (ch >= '\uFF10' && ch <= '\uFF19');
	}

	private static boolean isUnicodeConnectorPunctuation(int ch) {
		return (ch == '\u005F') || (ch >= '\u203F' && ch <= '\u2040')
				|| (ch == '\u2054') || (ch >= '\uFE33' && ch <= '\uFE34')
				|| (ch >= '\uFE4D' && ch <= '\uFE4F') || (ch == '\uFF3F');
	}
}
@parser::members {
	// options
	private List<Exception> mParseErrors;

	// private ASPrettyPrinter mPrinter;

	public boolean foundNextLT() {
		int i = 1;
		while (true) {
			Token token = input.LT(i);
			if (token.getText() != null && token.getText().startsWith("<"))
				return (i > 1);
			if (token.getType() == EOF)
				return false;
			i++;
		}
	}

	public void changeTokensUpToNextLT() {
		int i = 1;
		while (true) {
			Token t = input.LT(i);
			if (t.getText() != null && t.getText().startsWith("<"))
				return;
			if (t.getType() == EOF)
				return;
			t.setType(XML_TEXT);

			i++;
		}
	}

	public boolean findVirtualHiddenToken(ParserRuleReturnScope retval) {
		int index = retval.start.getTokenIndex();
		if (index < 0) {
			index = input.size();
		}
		for (int ix = index - 1; ix >= 0; ix--) {
			Token lt = input.get(ix);
			int type = lt.getType();
			if (lt.getChannel() == Token.DEFAULT_CHANNEL)
				break;
			if (type == EOL
					|| type == COMMENT_SINGLELINE
					|| (type == COMMENT_MULTILINE && lt.getText().matches(
							"/.*\r\n|\r|\n"))) {
				retval.start = lt;
				return true;
			}
		}
		return false;

	}

	public void reportError(RecognitionException e) {
		if (mParseErrors == null)
			mParseErrors = new ArrayList<Exception>();
		mParseErrors.add(e);
		super.reportError(e);
	}

	public List<Exception> getParseErrors() {
		return mParseErrors;
	}

	public static final int CHANNEL_SLCOMMENT = 43;
	public static final int CHANNEL_MLCOMMENT = 42;
	public static final int CHANNEL_WHITESPACE = 41;
	public static final int CHANNEL_EOL = 40;

	private final boolean promoteWhitespace(ParserRuleReturnScope rule) {
		Token lt = input.LT(1);
		int index = lt.getTokenIndex();
		if (index < 0) {
			index = input.size();
		}
		int la = lt.getType();

		for (int ix = index - 1; ix >= 0; ix--) {
			lt = input.get(ix);
			int type = lt.getType();
			if (type == WHITESPACE || type == EOL) {
				return true;
			} else if (lt.getChannel() == Token.DEFAULT_CHANNEL) {
				break;
			}
		}
		return false;
	}
}
// Lexer Helper Rule
fragment ALPHABET
	:	'a'..'z'|'A'..'Z'
	;
fragment NUMBER
	:	'0' .. '9'
	;
fragment HEX_DIGIT
	:	('0' .. '9'|'a'..'f'|'A'..'F')
	;
fragment CR
	:	'\r'
	;
fragment LF
	:	'\n'
	;
fragment UNICODE_ESCAPE 
	:	'\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
	;
fragment ESCAPE_SEQUENCE
	:	'\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') | UNICODE_ESCAPE
	;

// Lexer Ignored Rule
EOL
	:	CR? LF
	{ $channel = AS3Parser.CHANNEL_EOL; }
	;
WHITESPACE
	:	(('\u0020'|'\u0009'|'\u000B'|'\u000C')|('\u001C'..'\u001F'))+
	{ $channel = AS3Parser.CHANNEL_WHITESPACE; }
	;
COMMENT_MULTILINE
	:	'/*' ( options {greedy=false;} : . )* '*/'
	{ $channel = AS3Parser.CHANNEL_MLCOMMENT; }
	;
COMMENT_SINGLELINE
	:	'//' ~(CR | LF)* CR? LF
	{ $channel = AS3Parser.CHANNEL_SLCOMMENT; }
	;

// $<StringLiteral
SINGLE_QUOTE_LITERAL
	:	'\'' (ESCAPE_SEQUENCE | ~('\\'|'\''))* '\''
	;
DOUBLE_QUOTE_LITERAL
	:	'"' (ESCAPE_SEQUENCE | ~('\\'|'"'))* '"'
	;
// $>

// $<RegularExpressionLiteral
REGULAR_EXPR_LITERAL
	:	{isRegularExpression()}? => DIV REGULAR_EXPR_BODY DIV REGULAR_EXPR_FLAG*
	;

fragment REGULAR_EXPR_BODY
	:	REGULAR_EXPR_FIRST_CHAR REGULAR_EXPR_CHAR*
	;

// add > to the cannot be first char list
fragment REGULAR_EXPR_FIRST_CHAR
	:	~(CR | LF |'*'|'\\'|'/'|'>') | BACKSLASH_SEQUENCE
	;

fragment REGULAR_EXPR_CHAR
	:	~(CR | LF |'\\'|'/') | BACKSLASH_SEQUENCE
	;

fragment BACKSLASH_SEQUENCE
	:	'\\' ~(CR | LF)
	;

fragment REGULAR_EXPR_FLAG
	:	IDENT_PART
	;
// $>

// $<NumberLiteral

HEX_NUMBER_LITERAL
	:	'0' ('X'|'x') HEX_DIGIT+
	;

fragment DEC_NUMBER
	:	NUMBER+ '.' NUMBER* | '.' NUMBER+ | NUMBER+
	;

DEC_NUMBER_LITERAL
	:	DEC_NUMBER EXPONENT?
	;

fragment EXPONENT
	:	('e'|'E') ('+'|'-')? NUMBER+
	;
// $>

IDENTIFIER
	:	IDENT_NAME_ASCII_START | UNICODE_ESCAPE+ | {consumeIdentifierUnicodeStart();}
	;
	
fragment IDENT_NAME_ASCII_START
	:	IDENT_ASCII_START IDENT_PART*
	;

fragment IDENT_ASCII_START
	:	ALPHABET | DOLLAR | UNDERSCORE
	;
	
fragment IDENT_PART 
	:	(IDENT_ASCII_START) => IDENT_ASCII_START | NUMBER | {isUnicodeIdentifierPart(input.LA(1))}? {matchAny();}
	;

XML_COMMENT
	:	'<!--' ( options {greedy=false;} : . )* '-->'
	;

XML_CDATA options {k=8;}
	:	'<![CDATA' ( options {greedy=false;} : . )* ']]>'
	;

XML_PI
	:	'<?' ( options {greedy=false;} : . )* '?>'
	; 

// SourceCharacters but no embedded left-curly { or less-than <
XML_TEXT 
	: '\u0020'..'\u003b' | '\u003d'..'\u007a' | '\u007c'..'\u007e' | {isXMLText(input.LA(1))}?{matchAny();}
	;

// $<Literal
booleanLiteral
	:	TRUE | FALSE
	;
numericLiteral
	:	DEC_NUMBER_LITERAL | HEX_NUMBER_LITERAL
	;
stringLiteral
	:	SINGLE_QUOTE_LITERAL | DOUBLE_QUOTE_LITERAL
	;
regularExpresionLiteral
	:	REGULAR_EXPR_LITERAL
	;
identifierLiteral
	:	IDENTIFIER | notQuiteReservedWord
	;
xmlNameLiteral
	:	(IDENTIFIER | allKeywords) (SUB (IDENTIFIER | allKeywords))* 
	;
literal	:	NULL | booleanLiteral | numericLiteral | stringLiteral | regularExpresionLiteral
	;
// $>

// $<Xml

xmlMarkup
	:	xmlComment | xmlCDATA | xmlPI
	;
xmlComment
	:	XML_COMMENT
	;
xmlCDATA:	XML_CDATA
	;
xmlPI	:	XML_PI
	;
xmlExprEval
	:	LCURLY expression RCURLY
	;
xmlTextElement
	:	allKeywords | lexToken=(
	DEC_NUMBER_LITERAL | HEX_NUMBER_LITERAL | SINGLE_QUOTE_LITERAL | DOUBLE_QUOTE_LITERAL
	| IDENTIFIER
	| XML_TEXT //used to have a '+' on this item
	| DIV | SEMI 
//	| LCURLY //not allowed in xml text
	| RCURLY | LPAREN | RPAREN | LBRACK | RBRACK | DOT | COMMA
//	| LT //not allowed in xml text
	| GT | LTE
//	| GTE
	| EQ | NEQ | SAME | NSAME | PLUS | SUB | STAR | MOD | INC | DEC
	| SHL | SHR | SHU | AND | OR | XOR | NOT | INV | LAND | LOR | QUE | COLON | ASSIGN
	| UNDERSCORE | DOLLAR | MUL_ASSIGN | DIV_ASSIGN | MOD_ASSIGN | ADD_ASSIGN
	| SUB_ASSIGN | SHL_ASSIGN | SHR_ASSIGN | SHU_ASSIGN | AND_ASSIGN | XOR_ASSIGN
	| OR_ASSIGN | ELLIPSIS | XML_ELLIPSIS | XML_NS_OP | XML_AT
//	| XML_LS_STD
//	| XML_LS_END
	) 
	{ lexToken.setType(XML_TEXT); }
	;

xmlText
	:	(XML_TEXT | xmlTextElement)+ //xmlTextElement+
	;

// it's a helper rule,should not be a tree.
xmlPrimaryExpression
	:	xmlPropertyIdentifier | xmlInitialiser | xmlListInitialiser
	;

/* 
    XMLPropertyIdentifier can be a primary expression, but also can be a propertySuffixReference
    see example
        :   var xml:XML = <soap:Envelope soap:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"/>;
            var soapNS:Namespace = message.namespace("soap");
            trace(xml.@soapNS::encodingStyle); //-> it's a propertySuffixReference Call
            with(xml){
                trace(@soapNS::encodingStyle); //-> it's a primaryExpression Call
            }
*/
xmlPropertyIdentifier
	:	xmlAttributeIdentifier | xmlQualifiedIdentifier | STAR
	;

xmlAttributeIdentifier
	:	XML_AT (xmlPropertySelector | xmlQualifiedIdentifier | indexSuffix)
	; 

xmlPropertySelector
	:	xmlNameLiteral | STAR
	;

xmlQualifiedIdentifier
	:	xmlPropertySelector XML_NS_OP (xmlPropertySelector | indexSuffix)
	;

xmlInitialiser
	:	xmlMarkup | xmlElement
	;
	
xmlElement
	:	LT xmlTagName xmlAttributes? 
	(XML_TEND | GT xmlElementContent? XML_E_TEND xmlTagName GT)
	; 

xmlAttributes
	:	xmlAttribute+
	;

xmlTagName
	:	xmlExprEval | xmlNameLiteral
	; 

xmlAttribute
	:	{promoteWhitespace(null)}? xmlNameLiteral ASSIGN (xmlExprEval | stringLiteral)
	;

xmlElementContent
	:	xmlElementContentHelper+
	;

xmlElementContentHelper
	:	xmlExprEval | xmlMarkup | xmlElement | xmlText
	;

xmlListInitialiser
	:	XML_LS_STD xmlElementContent? XML_LS_END
	;
// $>

// semic rule
semic
@init
{
		// Mark current position so we can unconsume a RBRACE.
		int marker = input.mark();
		// Promote EOL if appropriate
		boolean onBrace = false;
		if (retval.start.getText() != null
				&& retval.start.getText().equals("}")) {
			onBrace = true;
			if (state.backtracking > 0) {
				retval.stop = retval.start;
				return retval; // we don't want to consume the '}' during the
								// prediction phase
			}
		}

		if (findVirtualHiddenToken(retval)) {
			retval.stop = retval.start;
			return retval;
		}

		// promoteEOL(retval);
}
	:	SEMI | EOF | RCURLY 
		{
			input.rewind(marker);
			if (onBrace)
				retval.start=input.LT(-1);
		}
	;


fileContents
	:	(packageDeclaration? packageElement*)^
	| EOF
	;

// $<Package Declaration

packageDeclaration
	:	PACKAGE^ (type)? LCURLY packageElement* RCURLY
	;

//this is for actionscript embedded within mxml. I believe that the semantics are that the code in
//the mx:Script blocks are embedded inside a virtual class declaration, so anything that is normally
//allowed inside a class should be okay. However, imports are okay too.
mxmlEmbedded
	:	(propertyDeclaration | functionDeclaration | statement | directive | interfaceFunctionDeclaration)* | EOF
	;

packageElement
	:	classDeclaration | interfaceDeclaration
	| propertyDeclaration
	| functionDeclaration
	| interfaceFunctionDeclaration
	| statement
	| directive
	;

importDeclaration
	:	IMPORT^ type (DOT STAR)? semic!
	;

//classOrInterfaceDecl
//	:	memberModifiers? (interfaceDeclaration | classDeclaration)
//	;
	
directive
	:	(bindingDecl | includeDirective | useNamespaceDirective | importDeclaration | /*namespaceDirective |*/ defaultXMLNamespaceDirective)
	;
	
xmlKeyword
	:	{input.LT(1).getText().equalsIgnoreCase("xml")}? IDENTIFIER 
	;
	
defaultXMLNamespaceDirective
	:	DEFAULT xmlKeyword NAMESPACE ASSIGN IDENTIFIER semic
	;	

bindingDecl
	:	LBRACK^ IDENTIFIER (LPAREN (bindingDeclArg (COMMA bindingDeclArg)*)? RPAREN)? RBRACK SEMI?
	;

includeDirective
	:	INCLUDE stringLiteral semic?
	-> ^(INCLUDE ^(stringLiteral) semic?)
	;

bindingDeclArg
	:	//TODO: figure out what's actually legal here
	(IDENTIFIER ASSIGN)? expression
//	| I=IDENTIFIER 
//	| T=TRUE
//	| F=FALSE
	;
// $>

// $<Class / Interface Body
interfaceDeclaration
	:	memberModifiers? INTERFACE type interfaceExtends? interfaceBody
	-> ^(INTERFACE type interfaceExtends? memberModifiers? interfaceBody)
	;
interfaceExtends
	:	EXTENDS^ typeList
	;

interfaceBody
	:	LCURLY^ interfaceElement* RCURLY
	;

classDeclaration
	:	memberModifiers? CLASS type classExtends? classImplements? classBody
	-> ^(CLASS type classExtends? classImplements? memberModifiers? classBody)
	;

classExtends
	:	EXTENDS^ type
	;
classImplements
	:	IMPLEMENTS^ typeList
	;

classBody
	:	LCURLY^ classBodyElement* RCURLY
	;
// $>
	 
// $<Class/Interface Element
classBodyElement
	:	propertyDeclaration
	| functionDeclaration
	| interfaceFunctionDeclaration 
	| statement
	| directive //| emptyStatement
	;

interfaceElement
	:	propertyDeclaration
	| interfaceFunctionDeclaration 
	| statement
	| directive
	//| emptyStatement
	;
// $>
	 

// $<InterfaceFunction Declaration
interfaceFunctionDeclaration
	:	memberModifiers? FUNCTION accessorModifier? IDENTIFIER formalParameterList (COLON type)?
	semic
	-> ^(FUNCTION IDENTIFIER ^(COLON type)? accessorModifier? memberModifiers? formalParameterList)
	|	memberModifiers? FUNCTION accessorModifier? NAMESPACE formalParameterList (COLON type)?
	semic
	-> ^(FUNCTION NAMESPACE ^(COLON type)? accessorModifier? memberModifiers? formalParameterList)
	;
	
// $>

// $<Property Declaration
propertyDeclaration
	:	memberModifiers? (
	variableStatement -> ^(variableStatement memberModifiers?)
	| constantVarStatement -> ^(constantVarStatement memberModifiers?)
	| namespaceDirective -> ^(namespaceDirective memberModifiers?)
	)
//	:	propertyVariableStatement | propertyConstVarStatement | propertyNamespaceDirective
	;
/*
propertyVariableStatement
	:	memberModifiers? variableStatement
	-> ^(variableStatement memberModifiers?)
	;
propertyConstVarStatement
	:	memberModifiers? constantVarStatement
	-> ^(constantVarStatement memberModifiers?)
	;
propertyNamespaceDirective
	:	memberModifiers? namespaceDirective
	-> ^(namespaceDirective memberModifiers?)
	;
*/
// $>

// $<Function Definition (13)
functionDeclaration
	:	memberModifiers? FUNCTION accessorModifier? IDENTIFIER formalParameterList (COLON type)?
	functionBody
	-> ^(FUNCTION IDENTIFIER ^(COLON type)? accessorModifier? memberModifiers? formalParameterList functionBody)
	|	memberModifiers? FUNCTION accessorModifier? NAMESPACE formalParameterList (COLON type)?
	functionBody
	-> ^(FUNCTION NAMESPACE ^(COLON type)? accessorModifier? memberModifiers? formalParameterList functionBody)

	;

accessorModifier
	:	SET|GET
	;

functionExpression
	:	FUNCTION (IDENTIFIER)? formalParameterList (COLON type)? functionBody
	;

formalParameterList
	:	LPAREN formalParameterListInner? RPAREN
	-> ^(LPAREN formalParameterListInner?)
	;
formalParameterListInner
	:	(variableDeclaration (COMMA variableDeclaration)* (COMMA formalEllipsisParameter)?)
	| formalEllipsisParameter
	;
formalEllipsisParameter
	:	ELLIPSIS variableIdentifierDecl -> ^(variableIdentifierDecl ELLIPSIS)
	;

functionBody
	:	LCURLY^ (statement!|functionDeclaration)* RCURLY 
	;
// $>

// $<Member Modifiers
memberModifiers
	:	memberModifier+
	;
//each
//	: {input.LT(1).getText().equals("each")}? I=IDENTIFIER 
//	;

memberModifier
	:	(
	DYNAMIC | FINAL | INTERNAL | NATIVE | OVERRIDE | PRIVATE | PROTECTED | PUBLIC | STATIC 
	| IDENTIFIER //this is to handle the case of namespaces, which apparently don't have to be before other modifiers
	)
	;
// $>


// statement

// $<Statement
statement
	:	(blockStatement | directive | namespaceDirective | expression semic 
	| constantVarStatement | tryStatement | labelledStatement | switchStatement 
	| withStatement | returnStatement | breakStatement | continueStatement 
	| forStatement | forInStatement | forEachInStatement | doWhileStatement 
	| whileStatement | ifStatement | emptyStatement | variableStatement | throwStatement
	)
	;
// $>


// $<Block Statement
blockStatement
	:	LCURLY statement* RCURLY
	;
// $>

throwStatement
	:	THROW expression semic
	;

// $<Constant Var Statement
constantVarStatement
	:	CONST variableDeclarationList (SEMI)?
	-> ^(CONST variableDeclarationList)
	; 
// $>

// $<UseNamespace Statement
useNamespaceDirective
	:	USE NAMESPACE qualifiedIdentifier (COMMA qualifiedIdentifier)* semic
	-> ^(USE ^(NAMESPACE qualifiedIdentifier+) semic)
	;
// $>

// $<Namespace Directive
namespaceDirective
	:	//(memberModifiers)? //namespace
	NAMESPACE qualifiedIdentifier namespaceDirectiveAssignment? semic
	-> ^(NAMESPACE qualifiedIdentifier namespaceDirectiveAssignment?)
	;
namespaceDirectiveAssignment
	:	ASSIGN stringLiteral
	-> ^(ASSIGN stringLiteral)
	;
// $>


// $<Try Statement(12.14)
tryStatement
	:	TRY blockStatement (catchClause+ finallyClause | catchClause+ | finallyClause)
	;

catchClause
	:	CATCH LPAREN variableIdentifierDecl RPAREN blockStatement
	;

finallyClause
	:	FINALLY blockStatement
	;
// $>

// $<Labelled Statement(12.12)
labelledStatement
	:	IDENTIFIER COLON statement
	;
// $>

// $<switch Statement(12.11)
switchStatement
	:	SWITCH parExpression LCURLY switchBlockStatementGroup* RCURLY 
	;

///* The change here (switchLabel -> switchLabel+) technically makes this grammar
//	ambiguous; but with appropriately greedy parsing it yields the most
//	appropriate AST, one in which each group, except possibly the last one, has
//	labels and statements. */
switchBlockStatementGroup
	:	switchLabel statement* breakStatement?
	;

switchLabel
	:	CASE expression COLON | DEFAULT COLON 
	;
// $>

// $<With statement(12.10)
withStatement
	:	WITH LPAREN expression RPAREN statement
	;
// $>

// $<Return statment (12.9)
returnStatement
	:	RETURN (expression?) semic 
	;
// $>

// $<Break statement (12.8)
breakStatement
	:	BREAK (IDENTIFIER)? semic
	;
// $>

// $<Continue statement (12.7)
continueStatement
	:	CONTINUE (IDENTIFIER)? semic
	;
// $>

// $<For statement 12.6
forStatement
	:	FOR LPAREN forControl RPAREN statement
	;

forInStatement
	:	FOR LPAREN forInControl RPAREN statement
	;

forEachInStatement
	:	FOR EACH LPAREN forInControl RPAREN statement
	;

forControl
options {k=3;} // be efficient for common case: for (ID ID : ID) ...
	:	forInit? semic expression? semic forUpdate?
	;

forInControl
options {k=3;} // be efficient for common case: for (ID ID : ID) ...
	:	forInDecl IN expression
	;

forInDecl
	:	leftHandSideExpression | VAR variableDeclarationNoIn
	;

forInit	:	variableDeclarationNoInList | expressionNoIn
	;

forUpdate
	:	expression
	;
// $>


// $<While statement (12.5)
doWhileStatement
	:	DO statement WHILE parExpression semic (SEMI)?
	;
// $>

// $<While statement (12.5)
whileStatement
	:	WHILE parExpression statement
	;
// $>

// $<If statement (12.5)
ifStatement
	:	IF parExpression statement (options {k=1;}:ELSE statement)?
	;
// $>

// $<Empty statement (12.3)
emptyStatement 
	:	SEMI
	;
// $>

// $<Variable statement 12.2)

variableStatement
	:	(IDENTIFIER)? VAR variableDeclarationList semic
	-> ^(VAR (IDENTIFIER)? variableDeclarationList)
	;

variableDeclarationList
	:	variableDeclaration (COMMA variableDeclaration)*
	;

variableDeclarationNoInList
	:	(VAR)? variableDeclarationNoIn (COMMA variableDeclarationNoIn)*
	;

variableDeclaration
	:	variableIdentifierDecl variableDelarationAssignment?
	-> ^(variableIdentifierDecl variableDelarationAssignment?)
	;
variableDelarationAssignment
	:	ASSIGN assignmentExpression
	-> ^(ASSIGN assignmentExpression)
	;

variableDeclarationNoIn
	:	variableIdentifierDecl (ASSIGN assignmentExpressionNoIn)?
	;

variableIdentifierDecl
	:	identifierLiteral (COLON type)?
	-> ^(identifierLiteral ^(COLON type)?)
	;
// $>

// $<Type / Type List
type	:	(qualifiedName | STAR | VOID)
	;

typeList:	type (COMMA type)*; 
// $>

standardQualifiedName
	:	((IDENTIFIER) (DOT (IDENTIFIER))*)
	;

qualifiedName 
	:	(standardQualifiedName (typePostfixSyntax)?)
	;

typePostfixSyntax
	:	(DOT LT standardQualifiedName GT)
	;

qualifiedIdentifier
	:	IDENTIFIER
	;

// Expression

parExpression
	:	LPAREN expression RPAREN
	;

expression
	:	assignmentExpression (COMMA assignmentExpression)*
	;

expressionNoIn
	:	assignmentExpressionNoIn (COMMA assignmentExpressionNoIn)*
	;

//11.13 Assignment Operators
assignmentExpression
	:	leftHandSideExpression assignmentOperator assignmentExpression | conditionalExpression
	;

assignmentExpressionNoIn
	:	conditionalExpressionNoIn | leftHandSideExpression assignmentOperator assignmentExpressionNoIn
	;

assignmentOperator
	:	assignmentOperator_int
	;

assignmentOperator_int
	:	ASSIGN | MUL_ASSIGN | DIV_ASSIGN | MOD_ASSIGN | ADD_ASSIGN | SUB_ASSIGN 
	| SHL_ASSIGN | SHR_ASSIGN | SHU_ASSIGN | AND_ASSIGN | XOR_ASSIGN | OR_ASSIGN
	;

//11.12 Conditional Operator ( ?: )
conditionalExpression
	:	logicalORExpression (QUE assignmentExpression COLON assignmentExpression)?
	;

conditionalExpressionNoIn
	:	logicalORExpressionNoIn (QUE assignmentExpression COLON assignmentExpression)?
	;

//11.11 Binary Logical Operators
logicalORExpression
	:	logicalANDExpression (LOR logicalANDExpression)*
	; 

logicalORExpressionNoIn
	:	logicalANDExpressionNoIn (LOR logicalANDExpressionNoIn)*
	;

logicalANDExpression
	:	bitwiseORExpression (LAND bitwiseORExpression)*
	;

logicalANDExpressionNoIn
	:	bitwiseORExpressionNoIn (LAND bitwiseORExpressionNoIn)*
	;

//11.10 Binary Bitwise Operators
bitwiseORExpression
	:	bitwiseXORExpression (OR bitwiseXORExpression)*
	;

bitwiseORExpressionNoIn
	:	bitwiseXORExpressionNoIn (OR bitwiseXORExpressionNoIn)*
	;

bitwiseXORExpression
	:	bitwiseANDExpression (XOR bitwiseANDExpression)*
	;

bitwiseXORExpressionNoIn
	:	bitwiseANDExpressionNoIn (XOR bitwiseANDExpressionNoIn)*
	;

bitwiseANDExpression
	:	equalityExpression (AND equalityExpression)*
	;

bitwiseANDExpressionNoIn
	:	equalityExpressionNoIn (AND equalityExpressionNoIn)*
	;

//11.9 Equality Operators
equalityExpression
	:	relationalExpression ((EQ|NEQ|SAME|NSAME) relationalExpression)*
	;

equalityExpressionNoIn
	:	relationalExpressionNoIn ((EQ|NEQ|SAME|NSAME) relationalExpressionNoIn)*
	;

//11.8 Relational Operators
relationalExpression
	:	shiftExpression 
	((g=GT (assign=ASSIGN)?
	{
		if (assign!=null) {
			g.setText(">=");
			g.setType(GTE);
		}
	} | (IN|LT|LTE|INSTANCEOF|IS|AS)) shiftExpression
	)*
	;

relationalExpressionNoIn
	:	shiftExpression 
	((g=GT (assign=ASSIGN)? 
	{
		if (assign!=null) {
			g.setText(">=");
			g.setType(GTE);
		}
	} |(LT|LTE|INSTANCEOF|IS|AS)) shiftExpression
	)*
	;

//11.7 Bitwise Shift Operators
shiftExpression
	:	additiveExpression ((SHL|SHR|SHU) additiveExpression)*
	;

//11.6 Additive Operators
additiveExpression
	:	multiplicativeExpression ((PLUS|SUB) multiplicativeExpression)*
	;

//11.5 Multiplicative Operators
multiplicativeExpression
	:	unaryExpression ((STAR|DIV|MOD)unaryExpression)*
	;

//11.4 Unary Operators
unaryExpression
	:	postfixExpression | unaryOp postfixExpression
	;

unaryOp	:	(DELETE | VOID | TYPEOF | INC | DEC | PLUS | SUB | INV | NOT)
	;

//11.3 Postfix Expressions
postfixExpression
	:	leftHandSideExpression postfixOp?
	;

postfixOp
	:	(INC | DEC)
	;

//These rules came from a grammar by Patrick Hulsmeijer, posted to the ANTLR examples
memberExpression
	:	primaryExpression | functionExpression | newExpression
	;

newExpression
	:	NEW primaryExpression
	;

//11.2
leftHandSideExpression
	:	memberExpression (arguments
		| LBRACK expression RBRACK 
//		| D=DOT (I=IDENTIFIER op=XML_NS_OP)? I=IDENTIFIER
		| DOT (eitherIdentifier XML_NS_OP)? eitherIdentifier
		| XML_ELLIPSIS eitherIdentifier
		| DOT parExpression
		| typePostfixSyntax
	)* // | x=XML_AT
	;

eitherIdentifier
	:	IDENTIFIER | xmlPropertyIdentifier | allKeywords
	;

notQuiteReservedWord
	:	(TO | NATIVE | EACH | GET | SET | NAMESPACE | DYNAMIC | FINAL | OVERRIDE | STATIC)
	;

allKeywords
	:	(reservedWord | notQuiteReservedWord)
	;

reservedWord
	:	(AS | BREAK | CASE | CATCH | CLASS | CONST | CONTINUE | DEFAULT | DELETE 
	| DO | ELSE | EXTENDS | FALSE | FINALLY | FOR | FUNCTION | IF | IMPLEMENTS | IMPORT 
	| IN | INSTANCEOF | INTERFACE | INTERNAL | IS
//	| NATIVE
	| NEW | NULL | PACKAGE | PRIVATE | PROTECTED | PUBLIC | RETURN | SUPER | SWITCH | THIS 
	| THROW | TRUE | TRY | TYPEOF | USE | VAR | VOID | WHILE | WITH 
//	| EACH
//	| GET
//	| SET
//	| NAMESPACE
	| INCLUDE
//	| DYNAMIC
//	| FINAL
//	| OVERRIDE
//	| STATIC)
	)
	;

arguments
	:	LPAREN (assignmentExpression (COMMA assignmentExpression)*)? RPAREN
	;

/*suffix helper rule*/ 
suffix	:	indexSuffix | propertyReferenceSuffix
	;

/*code like [i] or [1]*/
indexSuffix
	:	LBRACK expression RBRACK
	;

propertyReferenceSuffix
	:	DOT IDENTIFIER | DOT xmlPropertyIdentifier 
	| DOT /*it's a xml only reference match*/
	;

//11.1 Primary Expression
primaryExpression
	:	primaryExpressionHelper
	;

/* derived from ECMA-262 basicly. but add super alternative*/
primaryExpressionHelper
	:	THIS | SUPER | literal | arrayLiteral // ARRAY_LITERAL 
	| objectLiteral // OBJECT_LITERAL
	| identifierLiteral 
	| xmlPrimaryExpression
	| parExpression // PAR_EXPRESSION
	;

//11.1.5 Object Initialiser
objectLiteral
	:	LCURLY propertyNameAndValueList? RCURLY 
	;

propertyNameAndValueList
	:	propertyNameAndValue (COMMA propertyNameAndValue)*
	;

propertyNameAndValue
	:	propertyName COLON assignmentExpression
	;

propertyName
	:	identifierLiteral | stringLiteral | numericLiteral 
	;

//11.1.4 Array Initialiser
arrayLiteral
	:	LBRACK elementList? RBRACK 
	;

elementList
	:	assignmentExpression (COMMA assignmentExpression)* 
	(COMMA)? //allow extra comma on end, because it's apparently tolerated
	;
