
#ifndef _IOREGS_H_
#define _IOREGS_H_

#include "ep7211.h"

#define IO_START	0x80000000

#define IO(offset)	(IO_START + (offset))

#define IO_BYTE(offset)	(*(volatile unsigned char *)(IO_START + (offset)))
#define IO_WORD(offset)	(*(volatile unsigned long *)(IO_START + (offset)))

#define IO_PADR		IO_BYTE(PADR)
#define IO_PBDR		IO_BYTE(PBDR)
#define IO_PDDR		IO_BYTE(PDDR)
#define IO_PADDR	IO_BYTE(PADDR)
#define IO_PBDDR	IO_BYTE(PBDDR)
#define IO_PDDDR	IO_BYTE(PDDDR)
#define IO_PEDR		IO_BYTE(PEDR)
#define IO_PEDDR	IO_BYTE(PEDDR)
#define IO_SYSCON	IO_WORD(SYSCON)
#define	IO_SYSFLG	IO_WORD(SYSFLG)
#define	IO_MEMCFG1	IO_WORD(MEMCFG1)
#define	IO_MEMCFG2	IO_WORD(MEMCFG2)
#define IO_DRFPR	IO_WORD(DRFPR)
#define IO_INTSR	IO_WORD(INTSR)
#define IO_INTMR	IO_WORD(INTMR)
#define	IO_LCDCON	IO_WORD(LCDCON)
#define IO_TC1D		IO_WORD(TC1D)
#define IO_TC2D		IO_WORD(TC2D)
#define IO_RTCDR	IO_WORD(RTCDR)
#define IO_RTCMR	IO_WORD(RTCMR)
#define IO_PMPCON	IO_WORD(PMPCON)
#define IO_CODR 	IO_BYTE(CODR)
#define IO_UARTDR	IO_WORD(UARTDR)
#define IO_UBRLCR	IO_WORD(UBRLCR)
#define IO_SYNCIO	IO_WORD(SYNCIO)
#define	IO_PALLSW	IO_WORD(PALLSW)
#define	IO_PALMSW	IO_WORD(PALMSW)
#define IO_STFCLR	IO_WORD(STFCLR)
#define IO_BLEOI	IO_WORD(BLEOI)
#define IO_MCEOI	IO_WORD(MCEOI)
#define IO_TEOI		IO_WORD(TEOI)
#define IO_TC1EOI	IO_WORD(TC1EOI)
#define IO_TC2EOI	IO_WORD(TC2EOI)
#define IO_RTCEOI	IO_WORD(RTCEOI)
#define IO_UMSEOI	IO_WORD(UMSEOI)
#define IO_COEOI	IO_WORD(COEOI)
#define IO_HALT		IO_WORD(HALT)
#define IO_STDBY	IO_WORD(STDBY)
#define IO_SYSCON1	IO_WORD(SYSCON1)
#define IO_SYSFLG1	IO_WORD(SYSFLG1)
#define IO_INTSR1	IO_WORD(INTSR1)
#define IO_INTMR1	IO_WORD(INTMR1)
#define IO_UARTDR1	IO_WORD(UARTDR1)
#define IO_UBRLCR1	IO_WORD(UBRLCR1)
#define IO_FRBADDR	IO_WORD(FRBADDR)
#define IO_SYSCON2	IO_WORD(SYSCON2)
#define IO_SYSFLG2	IO_WORD(SYSFLG2)
#define IO_INTSR2	IO_WORD(INTSR2)
#define IO_INTMR2	IO_WORD(INTMR2)
#define IO_UARTDR2	IO_WORD(UARTDR2)
#define IO_UBRLCR2	IO_WORD(UBRLCR2)
#define IO_KBDEOI	IO_WORD(KBDEOI)

#define IO_MCCR		IO_WORD(MCCR)
#define IO_MCDR0	IO_WORD(MCDR0)
#define IO_MCDR1	IO_WORD(MCDR1)
#define IO_MCDR2	IO_WORD(MCDR2)
#define IO_MCSR		IO_WORD(MCSR)
#define IO_SYSCON3	IO_WORD(SYSCON3)
#define IO_INTSR3	IO_WORD(INTSR3)
#define IO_INTMR3	IO_WORD(INTMR3)
#define IO_LEDFLSH	IO_WORD(LEDFLSH)

#endif	/* _IOREGS_H_ */

