#include <target/buffer.h>
#include <target/flash.h>
#include <target/str.h>
#include <target/io.h>
#include "arch/memregions.h"
#include <target/setenv.h>

static int option_count = 0;
static char *options = 0;
static char *options_next = 0;
int get_option_count (void)
{
  unsigned long next_offset;
  char *p;
  int new_flag = 1;
  
  option_count = 0;
  
  for (options = (char *)FLASH_OPTION_START;
       options < (char *)(FLASH_OPTION_START + FLASH_OPTION_SIZE);
       options += next_offset) {
    next_offset = *(unsigned long *)options;
    if (next_offset == (unsigned long)0xffffffff) {
      options += sizeof(unsigned long);
      break;
    }
  }
  if (options >= (char *)(FLASH_OPTION_START + FLASH_OPTION_SIZE)) {
    options = (char *)FLASH_OPTION_START + sizeof(unsigned long);
    options_next = (char *)FLASH_OPTION_START + sizeof(unsigned long);
    return 1;
  }
  for (p = options;
       p < (char *)(FLASH_OPTION_START + FLASH_OPTION_SIZE);
       p++) {
    switch (*p) {
    case 0x0:
      new_flag = 1;
      break;
    case 0xff:
      if (!option_count) {
	options_next = p;
	return 1;
      }
      if ((int)p % sizeof(unsigned long)) {
	p += sizeof(unsigned long) - ((int)p % sizeof(unsigned long));
      }
      options_next = p + sizeof(unsigned long);
      return option_count + 1;
    default:
      if (new_flag) {
	option_count++;
	new_flag = 0;
      }
      break;
    }
  }
  
  option_count = 0;
  options = (char *)FLASH_OPTION_START + sizeof(unsigned long);
  options_next = (char *)FLASH_OPTION_START + sizeof(unsigned long);
  return 1;
}

void get_options (char *argv[])
{
  char *p;
  int i = 0;
  int new_flag = 1;
  
  argv[i++] = 0;

  if (!option_count) {
    return;
  }
  
  for (p = options; *p != 0xff; p++) {
    switch (*p) {
    case 0x0:
      new_flag = 1;
      break;
    default:
      if (new_flag) {
	argv[i++] = p;
	new_flag = 0;
      }
      break;
    }
  }
  
  return;
}


static void hex2str(char str[], unsigned long hex)
{
  int i;
  char c;
  
  str[0] = '0';
  str[1] = 'x';
  for (i = 0; i < 8; i++) {
    c = (hex >> ((7 - i) << 2)) & 0xf;
    str[2 + i] = ((c <= 9) ? '0' : ('a' - 10)) + c;
  }
  str[10] = 0;
}

static int setenv_cmdfunc(int argc, char *argv[])
{
  int i;
  unsigned char *p = dlbuf;
  char addr[16], size[16];
  int c_argc;
  char *c_argv[3];
  
  for (i = 1; i < argc; i++) {
    strcpy (p, argv[i]);
    p += strlen(p) + 1;
  }
  for (; (int)p % 4; p++) {
    *p = 0xff;
  }
  
  get_option_count();
  if (argc <= 1) {
    int offset = 0;
    for (i = 0; i < option_count; i++) {
      hprintf("%d: %s\n", i + 1, options + offset);
      offset += strlen(options + offset) + 1;
    }
    return 0;
  }
  if (options_next + (p - dlbuf) >=
      (char *)(FLASH_OPTION_START + FLASH_OPTION_SIZE)) {
    hex2str (addr, FLASH_OPTION_START);
    c_argc = 2;
    c_argv[0] = 0;
    c_argv[1] = addr;
    (*flash_erase_command.func)(c_argc, c_argv);
    option_count = 0;
    options = (char *)FLASH_OPTION_START + sizeof(unsigned long);
    options_next = (char *)FLASH_OPTION_START + sizeof(unsigned long);
  }
  else {
    if (options_next != options) {
      unsigned long temp = *(unsigned long *)dlbuf;
      *(unsigned long *)dlbuf = (unsigned long)(options_next - options);
      hex2str (addr, (unsigned long)(options - sizeof(unsigned long)));
      hex2str (size, sizeof(unsigned long));
      c_argc = 3;
      c_argv[0] = 0;
      c_argv[1] = addr;
      c_argv[2] = size;
      (*flash_program_command.func)(c_argc, c_argv);
      *(unsigned long *)dlbuf = temp;
    }
  }
  
  hex2str (addr, (unsigned long)options_next);
  hex2str (size, p - dlbuf);
  c_argc = 3;
  c_argv[0] = 0;
  c_argv[1] = addr;
  c_argv[2] = size;
  (*flash_program_command.func)(c_argc, c_argv);
  
  return 0;
}

static int clearenv_cmdfunc(int argc, char *argv[])
{
  char addr[16];
  int c_argc;
  char *c_argv[3];
  
  hex2str (addr, FLASH_OPTION_START);
  c_argc = 2;
  c_argv[0] = 0;
  c_argv[1] = addr;
  (*flash_erase_command.func)(c_argc, c_argv);
  option_count = 0;
  options = (char *)FLASH_OPTION_START + sizeof(unsigned long);
  options_next = (char *)FLASH_OPTION_START + sizeof(unsigned long);
  
  return 0;
}

const command_t setenv_command =
	{ "setenv", "<linux options>", "set Linux boot options", &setenv_cmdfunc };
const command_t clearenv_command =
	{ "clearenv", "", "clear Linux boot options", &clearenv_cmdfunc };
