/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <ep7211/ioregs.h>
#include <target/io.h>
#include "memmap.h"

static const char flash_blocking[] = "2x16K/l,6x16K,63x128K";

/*
 * The only vaguely tricky things about this memory map are:
 *
 * (1) It includes remapped memory addresses for the inverted mapping
 *     used by the CSC in boot mode, if we're compiling for that
 *     target.
 *
 * (2) Depicts flash block sizes as they are seen from outside the
 *     boot loader.  The flash parts are 16 bits wide (each spans 16
 *     bits of the data bus), so the blocks as seen by a flash
 *     programmer are twice data sheet size (of each 32-bit write, 16
 *     bits goes to each flash chip).
 */
static int memmap_cmdfunc(int argc, char *argv[])
{
#ifdef BOOTMODE
	hprintf("%p:%p@%p FLA flash-1 bf:8K bl:%s\n"
		"%p:%p@%p FLA flash-2 bf:8K bl:%s\n"
		"%p:%p@%p RAM onchip-sram\n"
		"%p:%p@%p ROM boot-rom\n"
		"%p:%p RAM dram-1\n"
		"%p:%p RAM dram-2\n",
		FLASH_BANK1_START, FLASH_BANK1_LAST, FLASH_BANK1_MAPPED,
		flash_blocking,
		FLASH_BANK2_START, FLASH_BANK2_LAST, FLASH_BANK2_MAPPED,
		flash_blocking,
		SRAM_START, SRAM_LAST, SRAM_MAPPED,
		BOOTROM_START, BOOTROM_LAST, BOOTROM_MAPPED,
		DRAM1_START, DRAM1_LAST, DRAM2_START, DRAM2_LAST);
#else
	hprintf("%p:%p FLA flash-1 bf:8K bl:%s\n"
		"%p:%p FLA flash-2 bf:8K bl:%s\n"
		"%p:%p RAM onchip-sram\n"
		"%p:%p ROM boot-rom\n"
		"%p:%p RAM dram-1\n"
		"%p:%p RAM dram-2\n",
		FLASH_BANK1_START, FLASH_BANK1_LAST, flash_blocking,
		FLASH_BANK2_START, FLASH_BANK2_LAST, flash_blocking,
		SRAM_START, SRAM_LAST, BOOTROM_START, BOOTROM_LAST,
		DRAM1_START, DRAM1_LAST, DRAM2_START, DRAM2_LAST);
#endif /* BOOTMODE */
	return 0;
}

const command_t memmap_command =
	{ "memmap", 0, "output memory map", &memmap_cmdfunc };

