/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <ep7211/ioregs.h>

#include "lcd.h"

/* LCD control constants */
#define VIDEO_BUFSIZE ((SCREENWIDTH * SCREENHEIGHT * COLORDEPTH) / 128 - 1)
#define VIDEO_LINELENGTH	(SCREENWIDTH / 16 - 1)
#define SYSCON1_LCD_ENABLE	0x00001000
#define PD1_LCD_DC_DC_EN	(1<<1)
#define PD2_LCDEN		(1<<2)
#define PD3_LCDBL		(1<<3)
#define LCD_GSMD		(1<<31)
#define LCD_GSEN		(1<<30)

static void lcd_clear(void)
{
	char *p = (char*) VIDEO_MEM_BASE;
	int i = VIDEO_MEM_SIZE;
	while (i--) *p++ = 0;
}

void lcd_init(void)
{
	volatile int i;

	/* configure LCD control registers */
	IO_PALLSW = 0x0000049f;
	IO_PALMSW = 0;
	IO_LCDCON = LCD_GSEN |		/* GSEN without GSMD == 2 bpp */
		(0x18 << 25) |			/* AC prescale */
		(3 << 19) |			/* pixel prescale */
		(VIDEO_LINELENGTH << 13) |
		VIDEO_BUFSIZE;

	/* clear screen buffer */
	lcd_clear();

	/* activate LCD and display backlight */
	IO_SYSCON1 |= SYSCON1_LCD_ENABLE;	/* activate LCD controller */
	IO_PDDR |= PD2_LCDEN;		/* turn LCD on */
	for (i=0; i<65536*4; ++i);	/* delay (demonstrated in lib7211) */
	IO_PDDR |= PD1_LCD_DC_DC_EN;	/* power up DC-DC converter */
}

void lcd_fini(void)
{
	volatile int i;

	/* clear screen buffer */
	lcd_clear();

	IO_PDDR &= ~PD1_LCD_DC_DC_EN;	/* power down DC-DC converter */
	for (i=0; i<65536*4; ++i);	/* delay (demonstrated in lib7211) */
	IO_PDDR &= ~PD2_LCDEN;		/* turn LCD off */
	IO_SYSCON1 &= ~SYSCON1_LCD_ENABLE;	/* disable LCD controller */
}

