/*
 * Copyright (c) 2001 Blue Mug, Inc.  All Rights Reserved.
 * Copyright (c) 2001-2005 Atmark Techno, Inc. All Rights Reserved.
 */

#include <target/str.h>

int strcmp(const char *s1, const char *s2)
{
	for (/* nada */; *s1 == *s2; ++s1, ++s2) {
		if (!*s1)
			return 0;
	}
	return ((int) *s1) - ((int) *s2);
}

int strncmp(const char *s1, const char *s2, size_t n)
{
	for (--n; *s1 == *s2; ++s1, ++s2, --n) {
		if (!n || !*s1)
			return 0;
	}
	return ((int) *s1) - ((int) *s2);
}

unsigned long strlen(const char *s)
{
	const char *p = s;
	while (*s) ++s;
	return s - p;
}

char *strcpy(char *s1, const char *s2)
{
	char *p = s1;
	for (; *s2; ++s1, ++s2) {
		*s1 = *s2;
	}
	*s1 = 0;
	return p;
}
