/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <target/herrno.h>
#include <target/io.h>
#include <target/scan.h>
#include <cs89712/memcpy.h>
#include <target/atag.h>
#include <target/gunzip.h>
#include "linux.h"
#include "memmap.h"
#include <target/memzero.h>

/* for setting the root device */
#define MINORBITS       8
#define MKDEV(ma,mi)    (((ma) << MINORBITS) | (mi))

#define RAMDISK_MAJOR   1	/* major for "RAM disk" */
#define RAMDISK0_MINOR	0	/* b 1 0 == /dev/ram0 */

#define ROM_FLASH_MAJOR	31	/* major for "ROM/flash memory card" */
#define FLASH0_MINOR	16	/* b 31 16 == /dev/flash0 */
#define FLASH1_MINOR	17	/* b 31 17 == /dev/flash1 */

#define COMMAND_LINE_SIZE 1024

static int linux_cmdfunc(int argc, char *argv[])
{
	struct tag *tag = (struct tag *) LINUX_PARAM_ADDRESS;

	/* zero param block */
	memzero (tag, LINUX_PARAM_SIZE);

	/* set up core tag */
	tag->hdr.tag = ATAG_CORE;
	tag->hdr.size = tag_size(tag_core);
	tag->u.core.flags = 0;
	tag->u.core.pagesize = 0x1000;
	tag->u.core.rootdev = MKDEV(RAMDISK_MAJOR, RAMDISK0_MINOR);

	/* 8 MB of SDRAM at 0x0 */
	tag = tag_next(tag);
	tag->hdr.tag = ATAG_MEM;
	tag->hdr.size = tag_size(tag_mem32);
	tag->u.mem.size = DRAM_SIZE >> 12;
	tag->u.mem.start = DRAM_START;

	/* an initial ramdisk image in flash at 0x00700000 */
	tag = tag_next(tag);
	tag->hdr.tag = ATAG_INITRD;
	tag->hdr.size = tag_size(tag_initrd);
	tag->u.initrd.start = INITRD_LOAD_ADDRESS;
	tag->u.initrd.size  = INITRD_SRC_SIZE;

	/* the command line arguments */
	if (argc > 1) {
		tag = tag_next(tag);
		tag->hdr.tag = ATAG_CMDLINE;
		tag->hdr.size = (COMMAND_LINE_SIZE + 3 +
			 sizeof(struct tag_header)) >> 2;

		{
			const unsigned char *src;
			unsigned char *dst;
			dst = tag->u.cmdline.cmdline;
			memzero (dst, COMMAND_LINE_SIZE);
			while (--argc > 0) {
				src = *++argv;
				hprintf ("Doing %s\n", src);
				while (*src)
					*dst++ = *src++;
				*dst++ = ' ';
			}
			*--dst = '\0';
		}
	}

	tag = tag_next(tag);
	tag->hdr.tag = 0;
	tag->hdr.size = 0;

	/* branch to kernel image */
        /* FIXME: we should set r0-r2 and change to SVC mode before jump to kernel */
        /* for now linux/arch/armnommu/kernel/head-arm-aj.S does it all */
	__asm__ volatile (
                "	mov	r4, #0x0\n"       \
                "	mov	pc, r4"
	);

	/* never get here */
	return 0;
}

static int boot_cmdfunc(int argc, char *argv[])
{
	gunzip_object (" kernel", LINUX_SRC_ADDRESS, LINUX_LOAD_ADDRESS);

	linux_cmdfunc (argc, argv);

	return 0;
}

const command_t linux_command =
	{ "linux", "<linux options>", "start Linux", &linux_cmdfunc };
const command_t boot_command =
	{ "boot", "", "boot default Linux kernel and ramdisk", &boot_cmdfunc };

